<?php
/**
 * Snax Frontend Submission Edit Functions
 *
 * @package snax
 * @subpackage Functions
 */

// Prevent direct script access.
if ( ! defined( 'ABSPATH' ) ) {
	die( 'No direct script access allowed' );
}

/**
 * Edit data
 *
 * @param WP $request       Request object.
 */
function snax_set_edit_data( $request ) {
	$format	 = filter_input( INPUT_GET, snax_get_url_var( 'format' ), FILTER_SANITIZE_STRING );
	$post_id = filter_input( INPUT_GET, snax_get_url_var( 'post' ), FILTER_SANITIZE_NUMBER_INT );

	if ( $post_id ) {
		$post = get_post( $post_id );

		/** Common part */

		// Title.
		$title = $post->post_title;

		// Category.
        $category_taxonomy = 'category';

        if ( 'extproduct' === $format ) {
            $category_taxonomy = 'product_cat';
        }

		$category_ids = array();
		$categories	 = wp_get_object_terms( $post_id, $category_taxonomy );

		if ( ! empty( $categories ) ) {
            foreach ( $categories as $category ) {
                $category_ids[] = $category->term_id;
            }
		}

		// Tags.
        $tag_taxonomy = 'post_tag';

        if ( 'extproduct' === $format ) {
            $tag_taxonomy = 'product_tag';
        }

		$tags 		= '';
		$term_ids 	= array();
		$terms 		= wp_get_post_terms( $post_id, $tag_taxonomy );

		if ( ! empty( $terms ) ) {
			foreach ( $terms as $term ) {
				$term_ids[] = $term->name;
			}

			$tags = implode( ',', $term_ids );
		}

		// Content.
		$content = $post->post_content;

		// Source.
		$source = '';

		/** Image Format */

		if ( in_array( $format, array( 'image', 'meme' ) ) ) {
			$caption = snax_get_caption_from_content( $content );

			// Source.
			if ( $caption['text'] ) {
				$source = $caption['text'];
			}

			// Set content without caption.
			$content = $caption['content'];
		}

        /** Audio Format */

        if ( in_array( $format, array( 'audio', 'video', 'embed' ) ) ) {
            // Set content without embed url.
            $content = snax_strip_embed_url_from_content( $content, $post );

            $source_data = snax_get_source_from_content( $content );

            $content = $source_data['content'];
            $source = $source_data['url'];
        }

        $url = '';

        /** Link Format **/
        if ( 'link' === $format ) {
            // Get link (a) from content.
            if ( preg_match( '/<a href="([^"]+)">[^<]+<\/a>/i', $content, $matches ) ) {
                $link = $matches[0];
                $url = $matches[1];

                $content = str_replace( $link, '', $content );
            }
        }

		/** Text Format */

		if ( 'text' === $format ) {
			$content = snax_conver_captions_into_froala_images( $content );
			$content = snax_conver_urls_into_froala_embeds( $content );
		}

		$content = apply_filters( 'snax_content_to_edit', $content, $format );

		/** Lists */

		$list_submission = 'standard' === get_post_meta( $post->ID, '_snax_post_submission', true );
		$list_voting 	 = 'standard' === get_post_meta( $post->ID, '_snax_post_voting', true );
		$ref_link 	     = get_post_meta( $post->ID, '_snax_ref_link', true );

		$request->set_query_var( 'snax_sanitized_field_values', array(
			'title'         	=> $title,
			'source'        	=> $source,
			'ref_link'        	=> $ref_link,
			'description'   	=> $content,
			'format'        	=> $format,
			'categories'   	    => $category_ids,
			'tags'          	=> $tags,
			'legal'         	=> true,
			'list_voting'       => $list_voting,
			'list_submission'	=> $list_submission,
			'url'	            => $url,
		) );

		// Allow to edit formats that are currently not active.
		add_filter( 'snax_frontend_submission_active_format_check', '__return_false' );
	}
}
