<?php
/**
 * Collection Intro
 *
 * @package snax 1.19
 * @subpackage Collections
 */
?>
<div class="snax-collection-intro">
	<p class="g1-gamma g1-gamma-3rd"><?php esc_html_e( 'Please log in to use the Read Later Collection and find posts you would like to read in the future.', 'snax' ); ?></p>

	<h2><?php esc_html_e( 'How Does It Work?', 'snax' ); ?></h2>

	<div class="snax-collection-intro-columns">
		<div class="snax-collection-intro-column">
			<div class="snax-collection-intro-icon snax-collection-intro-icon-read-later-1"></div>
			<h3><?php esc_html_e( 'Log In', 'snax' ); ?></h3>
			<p>
				<?php esc_html_e( 'The Read Later Collection is only available to logged in users, so please log in or register now.', 'snax' ); ?>
			</p>
		</div>
		<div class="snax-collection-intro-column">
			<div class="snax-collection-intro-icon snax-collection-intro-icon-read-later-2"></div>
			<h3><?php esc_html_e( 'Add Posts to Read Later', 'snax' ); ?></h3>
			<p>
				<?php esc_html_e( 'Pick up posts you would like to read in the future and add them to Read Later.', 'snax' ); ?>
				<?php esc_html_e( 'You can delete individual items or clear your entire collection.', 'snax' ); ?>
			</p>
		</div>
		<div class="snax-collection-intro-column">
			<div class="snax-collection-intro-icon snax-collection-intro-icon-read-later-3"></div>
			<h3><?php esc_html_e( 'Check Posts to Read Later', 'snax' ); ?></h3>
			<p>
				<?php esc_html_e( 'Easily find posts you would like to read in the future.', 'snax' ); ?>
				<?php esc_html_e( 'Other users won\'t have access to your Read Later Collection though.', 'snax' ); ?>
			</p>
		</div>
	</div>
</div>


