<?php 

//add assets to block editor
function novashare_block_editor_assets() {
    
    $novashare = get_option('novashare');
    
    //enqueue our block editor scripts + styles
    wp_enqueue_script('novashare-blocks-js', plugins_url('/js/blocks.js', __FILE__), array('wp-blocks', 'wp-element', 'wp-editor', 'wp-i18n'), NOVASHARE_VERSION);
    wp_set_script_translations('novashare-blocks-js', 'novashare', plugin_dir_path(__FILE__) . 'languages');
    wp_enqueue_style('novashare-blocks-css', plugins_url('/css/blocks.css', __FILE__), array( 'wp-edit-blocks' ), NOVASHARE_VERSION);
    
    if(!empty($novashare['pinterest']['image_pins'])) {
        wp_enqueue_script('novashare-blocks-pinterest-js', plugins_url('/js/blocks-pinterest.js', __FILE__), array('wp-blocks', 'wp-element', 'wp-editor', 'wp-i18n'), NOVASHARE_VERSION);
        wp_set_script_translations('novashare-blocks-pinterest-js', 'novashare', plugin_dir_path(__FILE__) . 'languages');
    }
    
    //pass our plugin options to our block editor script
    wp_localize_script('novashare-blocks-js', 'novashare', novashare_tinymce_localized_settings());
}

//hook assets to editor
add_action('enqueue_block_editor_assets', 'novashare_block_editor_assets');

//register and render gutenberg blocks
function novashare_register_blocks() {
    register_block_type(
        'novashare/click-to-tweet',
        array(
            'attributes' => array(
                'tweet' => array(
                    'type' => 'string'
                ),
                'cta_text' => array(
                    'type' => 'string'
                ),
                'cta_position' => array(
                    'type' => 'string'
                ),
                'remove_url' => array(
                    'type' => 'boolean'
                ),
                'remove_username' => array(
                    'type' => 'boolean'
                ),
                'hide_hashtags' => array(
                    'type' => 'boolean',
                    'default' => true
                )
            ),
            'render_callback' => 'novashare_click_to_tweet_block',
        )
        );
}
add_action('init', 'novashare_register_blocks');
