<?php
/**
 * Return SVG icons used by plugin
 * 
 * @package EasySocialShareButtons
 * @author appscreo
 * @since undefined
 */
class ESSB_SVG_Icons {
    
    /**
     * Register aliases of existing networks (share same icon)
     * @var array
     */
    public static $aliases = array(
        'yahoomail' => 'mail',
        'mailerlite' => 'subscribe',
        'mailchimp' => 'subscribe',
        'delicious' => 'del',
        'mailpoet' => 'subscribe',
        'mymail' => 'subscribe',
        'subscribe_form' => 'subscribe',
        'weheartit' => 'love',
        'total_followers' => 'love',
        'instgram' => 'instagram',
        'more' => 'plus',
        'less' => 'minus',
        'more_dots' => 'ellipsis-h',
        'yahoomail' => 'mail'
    );
        
    /**
     * List of all icons
     * @var array
     */
    public static $icons = array(
        'facebook' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M18.5 32v-14.625h4.875l0.75-5.688h-5.625v-3.625c0-1.625 0.438-2.75 2.813-2.75h3v-5.063c-0.5-0.125-2.313-0.25-4.375-0.25-4.375 0-7.313 2.625-7.313 7.5v4.188h-4.938v5.688h4.938v14.625z"></path></svg>',
        'twitter' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M28.75 9.5c0 0.25 0 0.563 0 0.813 0 8.688-6.625 18.688-18.688 18.688-3.688 0-7.188-1.063-10.063-2.938 0.5 0.063 1.063 0.063 1.563 0.063 3.063 0 5.938-1 8.188-2.813-2.875 0-5.313-1.938-6.188-4.563 0.438 0.125 0.813 0.125 1.25 0.125 0.625 0 1.188-0.063 1.75-0.188-3-0.625-5.25-3.313-5.25-6.438 0-0.063 0-0.063 0-0.125 0.875 0.5 1.875 0.813 2.938 0.813-1.75-1.125-2.938-3.188-2.938-5.438 0-1.188 0.375-2.313 0.938-3.313 3.188 4 8.063 6.625 13.5 6.875-0.125-0.5-0.188-1-0.188-1.5 0-3.625 2.938-6.563 6.563-6.563 1.938 0 3.625 0.813 4.813 2.063 1.5-0.313 2.938-0.813 4.188-1.563-0.5 1.5-1.563 2.813-2.875 3.625 1.313-0.188 2.563-0.5 3.75-1.063-0.875 1.313-2 2.5-3.25 3.438z"></path></svg>',
        'pinterest' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M10.625 12.25c0-1.375 0.313-2.5 1.063-3.438 0.688-0.938 1.563-1.438 2.563-1.438 0.813 0 1.438 0.25 1.875 0.813s0.688 1.25 0.688 2.063c0 0.5-0.125 1.125-0.313 1.813-0.188 0.75-0.375 1.625-0.688 2.563-0.313 1-0.563 1.75-0.688 2.313-0.25 1-0.063 1.875 0.563 2.625 0.625 0.688 1.438 1.063 2.438 1.063 1.75 0 3.188-1 4.313-2.938 1.125-2 1.688-4.375 1.688-7.188 0-2.125-0.688-3.875-2.063-5.25-1.375-1.313-3.313-2-5.813-2-2.813 0-5.063 0.875-6.75 2.688-1.75 1.75-2.625 3.875-2.625 6.375 0 1.5 0.438 2.75 1.25 3.75 0.313 0.313 0.375 0.688 0.313 1.063-0.125 0.313-0.25 0.813-0.375 1.5-0.063 0.25-0.188 0.438-0.375 0.5s-0.375 0.063-0.563 0c-1.313-0.563-2.25-1.438-2.938-2.75s-1-2.813-1-4.5c0-1.125 0.188-2.188 0.563-3.313s0.875-2.188 1.625-3.188c0.75-1.063 1.688-1.938 2.688-2.75 1.063-0.813 2.313-1.438 3.875-1.938 1.5-0.438 3.125-0.688 4.813-0.688 1.813 0 3.438 0.313 4.938 0.938 1.5 0.563 2.813 1.375 3.813 2.375 1.063 1.063 1.813 2.188 2.438 3.5 0.563 1.313 0.875 2.688 0.875 4.063 0 3.75-0.938 6.875-2.875 9.313-1.938 2.5-4.375 3.688-7.375 3.688-1 0-1.938-0.188-2.813-0.688-0.875-0.438-1.5-1-1.875-1.688-0.688 2.938-1.125 4.688-1.313 5.25-0.375 1.438-1.25 3.188-2.688 5.25h-1.313c-0.25-2.563-0.188-4.688 0.188-6.375l2.438-10.313c-0.375-0.813-0.563-1.813-0.563-3.063z"></path></svg>',
        'linkedin' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M23.938 16.375c-0.438-0.5-1.188-0.75-2.25-0.75-1.375 0-2.313 0.438-2.875 1.188-0.563 0.813-0.813 1.938-0.813 3.375v10.938c0 0.188-0.063 0.375-0.25 0.563-0.125 0.125-0.375 0.25-0.563 0.25h-5.75c-0.188 0-0.375-0.125-0.563-0.25-0.125-0.188-0.25-0.375-0.25-0.563v-20.188c0-0.188 0.125-0.375 0.25-0.563 0.188-0.125 0.375-0.25 0.563-0.25h5.563c0.188 0 0.375 0.063 0.5 0.125s0.188 0.25 0.25 0.438c0 0.188 0.063 0.375 0.063 0.438s0 0.25 0 0.5c1.438-1.375 3.375-2 5.688-2 2.688 0 4.75 0.625 6.25 1.938 1.5 1.375 2.25 3.313 2.25 5.938v13.625c0 0.188-0.063 0.375-0.25 0.563-0.125 0.125-0.375 0.25-0.563 0.25h-5.875c-0.188 0-0.375-0.125-0.563-0.25-0.125-0.188-0.25-0.375-0.25-0.563v-12.313c0-1.063-0.188-1.875-0.563-2.438zM6.625 6.688c-0.75 0.75-1.688 1.125-2.75 1.125s-2-0.375-2.75-1.125c-0.75-0.75-1.125-1.625-1.125-2.75 0-1.063 0.375-1.938 1.125-2.688s1.688-1.188 2.75-1.188c1.063 0 2 0.438 2.75 1.188s1.125 1.625 1.125 2.688c0 1.125-0.375 2-1.125 2.75zM7.563 10.938v20.188c0 0.188-0.125 0.375-0.25 0.563-0.188 0.125-0.375 0.25-0.563 0.25h-5.75c-0.188 0-0.375-0.125-0.563-0.25-0.125-0.188-0.25-0.375-0.25-0.563v-20.188c0-0.188 0.125-0.375 0.25-0.563 0.188-0.125 0.375-0.25 0.563-0.25h5.75c0.188 0 0.375 0.125 0.563 0.25 0.125 0.188 0.25 0.375 0.25 0.563z"></path></svg>',
        'digg' => '<svg height="32" viewBox="0 0 32 32" width="32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="m7.186 4.5h2.405v2.391h-2.405z"/><path d="m24 8.078h-6.239v8.173h3.834v1.336h-3.834v1.913h6.239zm-2.405 6.251h-1.444v-4.327h1.444z"/><path d="m7.186 8.077h2.405v8.175h-2.405z"/><path d="m6.22 4.5h-2.391v3.577h-3.829v8.175h6.22zm-2.39 9.829h-1.444v-4.327h1.444z"/><path d="m16.8 8.078h-6.248v8.173h3.848v1.336h-3.848v1.913h6.248zm-2.404 6.251h-1.444v-4.327h1.444z"/></svg>',
        'del' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M32 16h-16v16h-16v-16h16v-16h16z"></path></svg>',
        'tumblr' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M6.125 13.125v-4.563c1.25-0.375 2.375-1 3.25-1.75s1.625-1.688 2.125-2.75c0.563-1.063 0.938-2.438 1.125-4.063h4.563v8.063h7.625v5.063h-7.625v8.188c0 1.875 0.125 3.063 0.313 3.563 0.188 0.563 0.563 0.938 1.063 1.25 0.75 0.438 1.563 0.688 2.438 0.688 1.625 0 3.25-0.563 4.875-1.625v5.063c-1.375 0.625-2.625 1.125-3.75 1.375-1.063 0.25-2.313 0.375-3.563 0.375-1.5 0-2.75-0.188-3.875-0.563s-2.125-0.875-2.875-1.563c-0.813-0.688-1.375-1.438-1.688-2.188s-0.438-1.875-0.438-3.375v-11.188z"></path></svg>',
        'vk' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M30.938 22.063c-0.938-1.25-1.75-2-2.938-3.125-0.5-0.5-1.188-1-1.25-1.688-0.063-0.938 0.813-1.813 1.25-2.438 0.063-0.063 0.125-0.125 0.188-0.188s0.063-0.063 0.125-0.125c0-0.063 0.063-0.063 0.063-0.125 0.063-0.063 0.063-0.125 0.125-0.125 0-0.063 0.063-0.063 0.063-0.063 0.063-0.063 0.063-0.125 0.125-0.188 0.813-1.063 1.625-2 2.438-3.25 0.25-0.438 1.063-2 0.813-2.625-0.375-0.75-2.313-0.5-3.375-0.5-1.313 0-2.75-0.25-3.688 0.125-0.563 0.188-0.938 1.438-1.25 2.125-0.5 1.063-0.938 1.938-1.438 2.75 0 0.063-0.063 0.125-0.125 0.188 0 0 0 0 0 0 0 0.063-0.063 0.125-0.125 0.188 0 0 0 0 0 0-0.063 0.125-0.125 0.25-0.188 0.313 0 0.063-0.063 0.063-0.063 0.063 0 0.063-0.063 0.063-0.063 0.125-0.063 0.063-0.063 0.063-0.063 0.125-0.063 0-0.063 0.063-0.125 0.125 0 0-0.063 0.063-0.063 0.125-0.063 0-0.063 0.063-0.063 0.063-0.063 0.063-0.125 0.125-0.188 0.25-0.438 0.625-0.875 1.375-1.688 1.5-0.063-0.063-0.063-0.063-0.125-0.063 0 0 0-0.063 0-0.063-0.063 0-0.063 0-0.063 0 0-0.063-0.063-0.063-0.063-0.063s0 0-0.063-0.063c0 0 0 0 0 0s0-0.063-0.063-0.063c0 0 0 0 0 0 0-0.063-0.063-0.063-0.063-0.063s0-0.063 0-0.063c0 0-0.063 0-0.063-0.063 0 0 0 0 0 0 0-0.063 0-0.063-0.063-0.063 0 0 0-0.063 0-0.063s0 0 0-0.063c0 0-0.063 0-0.063 0 0-0.063 0-0.063 0-0.125 0 0 0 0 0 0-0.063-0.063-0.063-0.063-0.063-0.063 0-0.063 0-0.063 0-0.063s0-0.063 0-0.063c0 0 0-0.063-0.063-0.063 0 0 0-0.063 0-0.063s0 0 0-0.063c0 0 0 0 0-0.063 0 0 0 0 0 0 0-0.063 0-0.063-0.063-0.063 0-0.063 0-0.063 0-0.063 0-0.063 0-0.063 0-0.063 0-0.063 0-0.063 0-0.063 0-0.063 0-0.063 0-0.063 0-0.063 0-0.063 0-0.063 0-0.063 0-0.063 0-0.125 0 0 0 0 0 0 0-0.063 0-0.063 0-0.125 0 0 0 0 0 0 0-0.063 0-0.063 0-0.125 0 0-0.063 0-0.063-0.063 0 0 0-0.063 0-0.063s0-0.063 0-0.063c0 0 0-0.063 0-0.063s0-0.063 0-0.063c0 0 0-0.063 0-0.063 0-0.063 0.063-0.063 0.063-0.063 0-0.063 0-0.063 0-0.063 0-0.063 0-0.063 0-0.063 0-0.063 0-0.063 0-0.125 0 0 0 0 0 0 0-0.063 0-0.063 0-0.125 0 0 0 0 0 0 0-0.188 0-0.313 0-0.5 0 0 0-0.063 0-0.063 0-0.125 0-0.313 0.063-0.438 0-1.375 0.438-3.188-0.188-4.25-0.563-0.938-2.688-0.813-4.188-0.813-1.813 0-3.25 0.125-3.813 1.188 0.625 0.438 1.313 0.438 1.625 1.063 0.375 0.688 0.438 2.125 0.375 3.438 0 0.063 0 0.125 0 0.188 0 1.125-0.063 2.938-0.813 3.063s-1.375-1-1.813-1.563c-0.063-0.125-0.125-0.188-0.188-0.313 0 0-0.063-0.063-0.063-0.063-0.063-0.063-0.063-0.125-0.125-0.25 0 0-0.063-0.063-0.063-0.063-0.063-0.063-0.125-0.125-0.125-0.188-0.063-0.063-0.063-0.063-0.063-0.125-0.063-0.063-0.125-0.188-0.188-0.25-0.563-0.938-1.125-1.875-1.625-3.063-0.375-0.688-0.813-1.875-1.188-2.063-0.75-0.375-2.25-0.188-3.25-0.188-1.125 0-2.313-0.188-3 0.375 0 1.25 0.625 2.313 1.125 3.313 0.688 1.375 1.375 2.688 2.125 3.938 0 0.063 0.063 0.125 0.063 0.188 0.125 0.125 0.188 0.313 0.313 0.438 0 0.063 0.063 0.125 0.063 0.188 0.125 0.125 0.188 0.313 0.313 0.438 0 0.063 0.063 0.125 0.125 0.188 0.125 0.188 0.25 0.375 0.375 0.563 0 0 0 0 0 0 0.125 0.188 0.25 0.438 0.375 0.625 0.063 0.063 0.063 0.125 0.125 0.125 0.125 0.188 0.188 0.313 0.313 0.438 0 0.063 0.063 0.125 0.125 0.188 0.063 0.125 0.188 0.313 0.313 0.438 0 0.063 0.063 0.125 0.125 0.188 0.125 0.188 0.25 0.375 0.438 0.563 1.938 2.438 4.125 4.75 8.438 5.25 1.375 0.125 3.375 0.25 3.813-0.563 0.625-1-0.063-3.375 1.313-3.563 0.938-0.188 1.75 1.25 2.313 1.813 0.938 1.063 2.063 2.188 3.688 2.5 0 0 0.063 0 0.125 0 1.438-0.625 5.75 0.688 6-1.125 0.063-0.625-0.688-1.625-1.063-2.063z"></path></svg>',
        'print' => '<svg width="30" height="32" viewBox="0 0 30 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M6.857 27.714h16v-4.571h-16v4.571zM6.857 16.286h16v-6.857h-2.857c-0.946 0-1.714-0.768-1.714-1.714v-2.857h-11.429v11.429zM27.429 17.429c0-0.625-0.518-1.143-1.143-1.143s-1.143 0.518-1.143 1.143 0.518 1.143 1.143 1.143 1.143-0.518 1.143-1.143zM29.714 17.429v7.429c0 0.304-0.268 0.571-0.571 0.571h-4v2.857c0 0.946-0.768 1.714-1.714 1.714h-17.143c-0.946 0-1.714-0.768-1.714-1.714v-2.857h-4c-0.304 0-0.571-0.268-0.571-0.571v-7.429c0-1.875 1.554-3.429 3.429-3.429h1.143v-9.714c0-0.946 0.768-1.714 1.714-1.714h12c0.946 0 2.25 0.536 2.929 1.214l2.714 2.714c0.679 0.679 1.214 1.982 1.214 2.929v4.571h1.143c1.875 0 3.429 1.554 3.429 3.429z" /></svg>',
        'subscribe' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M32 12.964v14.179c0 1.571-1.286 2.857-2.857 2.857h-26.286c-1.571 0-2.857-1.286-2.857-2.857v-14.179c0.536 0.589 1.143 1.107 1.804 1.554 2.964 2.018 5.964 4.036 8.875 6.161 1.5 1.107 3.357 2.464 5.304 2.464h0.036c1.946 0 3.804-1.357 5.304-2.464 2.911-2.107 5.911-4.143 8.893-6.161 0.643-0.446 1.25-0.964 1.786-1.554zM32 7.714c0 2-1.482 3.804-3.054 4.893-2.786 1.929-5.589 3.857-8.357 5.804-1.161 0.804-3.125 2.446-4.571 2.446h-0.036c-1.446 0-3.411-1.643-4.571-2.446-2.768-1.946-5.571-3.875-8.339-5.804-1.268-0.857-3.071-2.875-3.071-4.5 0-1.75 0.946-3.25 2.857-3.25h26.286c1.554 0 2.857 1.286 2.857 2.857z"/></svg>',
        'mail' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M507.49,101.721L352.211,256L507.49,410.279c2.807-5.867,4.51-12.353,4.51-19.279V121C512,114.073,510.297,107.588,507.49,101.721z"/></g></g><g><g><path d="M467,76H45c-6.927,0-13.412,1.703-19.279,4.51l198.463,197.463c17.548,17.548,46.084,17.548,63.632,0L486.279,80.51C480.412,77.703,473.927,76,467,76z"/></g></g><g><g><path d="M4.51,101.721C1.703,107.588,0,114.073,0,121v270c0,6.927,1.703,13.413,4.51,19.279L159.789,256L4.51,101.721z"/></g></g><g><g><path d="M331,277.211l-21.973,21.973c-29.239,29.239-76.816,29.239-106.055,0L181,277.211L25.721,431.49C31.588,434.297,38.073,436,45,436h422c6.927,0,13.412-1.703,19.279-4.51L331,277.211z"/></svg>',
        'flattr' => '<svg height="32" viewBox="0 0 32 32" width="32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M7.2,13v8.4L0,28.6V12.1C0,4.1,3.7,0,11.2,0h9.2h8.4L16.3,12.4c-0.2,0.2-0.3,0.2-0.4,0.2c-0.2,0-0.4-0.2-0.5-0.4v-0.2v-5c-2.7,0-4.1,0.1-4.5,0.1C8.4,7.6,7.2,9.6,7.2,13 M24.8,10.5L32,3.3v16.5C32,27.9,28.3,32,20.8,32h-9.2H3.3l12.5-12.5c0.1-0.2,0.2-0.2,0.3-0.2c0.2,0,0.4,0.2,0.5,0.4v0.2v5c2.7,0,4.1-0.1,4.5-0.1c2.5-0.5,3.7-2.4,3.7-5.9V10.5"/></svg>',
        'reddit' => '<svg height="32" viewBox="0 0 32 32" width="32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="m21.325 9.308c-.758 0-1.425.319-1.916.816-1.805-1.268-4.239-2.084-6.936-2.171l1.401-6.406 4.461 1.016c0 1.108.89 2.013 1.982 2.013 1.113 0 2.008-.929 2.008-2.038s-.889-2.038-2.007-2.038c-.779 0-1.451.477-1.786 1.129l-4.927-1.108c-.248-.067-.491.113-.557.365l-1.538 7.062c-2.676.113-5.084.928-6.895 2.197-.491-.518-1.184-.837-1.942-.837-2.812 0-3.733 3.829-1.158 5.138-.091.405-.132.837-.132 1.268 0 4.301 4.775 7.786 10.638 7.786 5.888 0 10.663-3.485 10.663-7.786 0-.431-.045-.883-.156-1.289 2.523-1.314 1.594-5.115-1.203-5.117zm-15.724 5.41c0-1.129.89-2.038 2.008-2.038 1.092 0 1.983.903 1.983 2.038 0 1.109-.89 2.013-1.983 2.013-1.113.005-2.008-.904-2.008-2.013zm10.839 4.798c-1.841 1.868-7.036 1.868-8.878 0-.203-.18-.203-.498 0-.703.177-.18.491-.18.668 0 1.406 1.463 6.07 1.488 7.537 0 .177-.18.491-.18.668 0 .207.206.207.524.005.703zm-.041-2.781c-1.092 0-1.982-.903-1.982-2.011 0-1.129.89-2.038 1.982-2.038 1.113 0 2.008.903 2.008 2.038-.005 1.103-.895 2.011-2.008 2.011z"/></svg>',
        'buffer' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M31.438 24.313c-0.063-0.063-0.188-0.125-0.25-0.188-0.813-0.375-1.688-0.75-2.5-1.125-0.688-0.375-1.438-0.375-2.188 0-3.125 1.438-6.25 2.938-9.375 4.375-0.75 0.313-1.5 0.375-2.188 0-3.125-1.438-6.313-2.938-9.438-4.375-0.75-0.375-1.5-0.375-2.25 0s-1.563 0.75-2.313 1.063c-0.25 0.125-0.625 0.25-0.625 0.625 0 0.313 0.375 0.375 0.625 0.5 4.625 2.188 9.25 4.375 13.938 6.5 0.75 0.375 1.5 0.375 2.188 0.063 4.688-2.188 9.375-4.375 14.063-6.563 0.125-0.063 0.25-0.125 0.313-0.188 0.313-0.188 0.313-0.5 0-0.688zM0.5 7.688c0.125 0.063 0.313 0.188 0.438 0.25 4.688 2.125 9.313 4.313 13.938 6.5 0.75 0.313 1.5 0.313 2.25 0 4.625-2.188 9.313-4.375 13.938-6.5 0.125-0.125 0.313-0.188 0.438-0.313 0.25-0.125 0.25-0.375 0-0.563-0.125-0.125-0.313-0.188-0.438-0.313-4.625-2.125-9.25-4.313-13.875-6.438-0.813-0.375-1.563-0.375-2.375 0-4.625 2.125-9.25 4.313-13.875 6.5-0.188 0.063-0.313 0.125-0.438 0.188-0.25 0.188-0.25 0.5 0 0.688zM31.438 15.688c-0.063-0.063-0.188-0.125-0.25-0.188-0.813-0.375-1.688-0.75-2.5-1.125-0.688-0.375-1.438-0.375-2.188 0-3.125 1.438-6.25 2.938-9.375 4.375-0.75 0.313-1.5 0.313-2.188 0-3.125-1.438-6.313-2.938-9.438-4.375-0.75-0.375-1.5-0.375-2.25 0s-1.563 0.75-2.313 1.063c-0.25 0.125-0.625 0.25-0.625 0.563 0 0.375 0.375 0.438 0.625 0.563 4.625 2.188 9.25 4.375 13.938 6.5 0.75 0.375 1.5 0.375 2.188 0.063 4.688-2.188 9.375-4.375 14.063-6.563 0.125-0.063 0.25-0.125 0.313-0.188 0.313-0.188 0.313-0.5 0-0.688z"/></svg>',
        'love' => '<svg version="1.1" height="32" width="37" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 37 32" ><path d="M33.2,2.2c-3.9-3.3-9.7-2.7-13.3,1l-1.4,1.4l-1.4-1.4c-3.6-3.7-9.4-4.3-13.3-1C-0.7,6-1,12.9,3.1,17l13.8,14.3c0.9,0.9,2.3,0.9,3.2,0L33.9,17C38,12.9,37.7,6,33.2,2.2L33.2,2.2z"/></svg>',
        'weibo' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="m23.977 8.171c.103 1.315-.123 2.891-1.006 2.969-1.442.127-.69-1.435-.671-2.375.053-2.725-2.312-4.618-4.629-4.618-.656 0-2.181.438-1.946-.924.106-.6.623-.592 1.14-.66 3.897-.51 6.838 2.125 7.112 5.608z"/><path d="m17.604 11.337c1.675.901 3.687 1.35 3.354 4.024-.614 4.929-11.054 8.24-17.575 4.618-1.788-.994-3.639-2.448-3.354-5.344.246-2.493 1.95-4.424 3.623-6.069 1.596-1.57 3.278-2.798 5.567-3.364 2.484-.614 3.218 1.422 2.549 3.43 1.439-.095 4.488-1.674 5.836-.132.594.68.367 1.897 0 2.837zm-1.811 6.333c.537-.598 1.076-1.51 1.073-2.572-.01-4.395-7.635-5.376-11.806-2.969-4.747 2.74-2.743 7.664 3.086 8.048 3.088.204 6.179-.868 7.647-2.507z"/><path d="m19.952 10.084c-.977.064-.612-.658-.671-1.517-.037-.529-.483-1.14-.872-1.32-.763-.352-1.945.256-1.945-.791 0-.778.686-.697 1.074-.726 3.555-.266 3.775 4.265 2.414 4.354z"/><path d="m12.842 14.768c1.429 4.248-6.017 6.223-7.379 2.573-.911-2.441 1.277-4.383 3.555-4.618 1.945-.201 3.395.775 3.824 2.045zm-3.422.726c.303.516 1 .145.939-.264-.073-.473-.945-.403-.939.264zm-1.207 2.243c1.252-.293 1.42-2.612-.47-2.177-1.587.364-1.28 2.586.47 2.177z"/></svg>',
        'pocket' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M32 5.5c0-0.875 0.063-1.688-0.438-2.438-0.375-0.563-1-1.063-1.625-1.25-0.875-0.25-1.813-0.188-2.625-0.125-3.75 0-7.563-0.063-11.313-0.063-0.438 0-0.813 0-1.25 0-0.5 0-1 0-1.563 0-1.813 0-3.688 0-5.563 0-0.938 0-1.875 0-2.813 0-0.5 0-1 0-1.5 0-0.438 0-0.813 0-1.188 0.125-1.313 0.375-2.125 1.625-2.125 3 0 1.875 0 3.75 0 5.625 0 1.813-0.063 3.688 0.063 5.563 0.125 1.688 0.625 3.438 1.313 5 1.313 2.813 3.438 5.188 6.063 6.875 2.875 1.813 6.313 2.688 9.688 2.438 3.313-0.25 6.5-1.563 9.063-3.688 2.438-1.938 4.188-4.563 5.125-7.5 0.5-1.688 0.688-3.5 0.688-5.25 0-1.813 0-3.688 0-5.563 0-0.938 0-1.875 0-2.75zM25.625 12.75c-0.188 0.813-1 1.375-1.563 1.938-1.438 1.375-2.875 2.75-4.313 4.063-0.75 0.75-1.438 1.438-2.188 2.125-0.563 0.5-1.313 0.75-2.063 0.563-0.875-0.188-1.5-1-2.063-1.563-0.75-0.688-1.438-1.375-2.125-2-1.438-1.375-2.875-2.75-4.313-4.188-1.063-1.063-0.875-3 0.625-3.625 0.688-0.25 1.5-0.188 2.063 0.188 0.375 0.313 0.75 0.625 1.063 1 0.375 0.313 0.75 0.688 1.063 1 1.438 1.375 2.75 2.75 4.188 4 1.625-1.5 3.25-3.063 4.875-4.625 0.688-0.625 1.313-1.5 2.313-1.688 0.75-0.125 1.563 0.188 2.063 0.75 0.438 0.563 0.625 1.375 0.375 2.063z"/></svg>',
        'xing' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M7.688 22.438h-4.625c-0.25 0-0.438-0.125-0.563-0.313s-0.125-0.5 0-0.75l4.875-8.625c0 0 0 0 0-0.063l-3.125-5.375c-0.125-0.25-0.125-0.5 0-0.688s0.313-0.313 0.625-0.313h4.625c0.688 0 1.063 0.438 1.25 0.875 0 0 3.188 5.5 3.188 5.5-0.188 0.375-5 8.813-5 8.813-0.25 0.438-0.563 0.938-1.25 0.938zM29.5 1l-10.188 18.063c0 0 0 0.063 0 0.063l6.5 11.875c0.125 0.25 0.125 0.5 0 0.688s-0.313 0.313-0.625 0.313h-4.625c-0.688 0-1-0.5-1.25-0.875 0 0-6.563-12-6.563-12.063 0.313-0.563 10.25-18.188 10.25-18.188 0.25-0.438 0.563-0.875 1.25-0.875h4.688c0.25 0 0.5 0.125 0.563 0.313 0.125 0.188 0.125 0.438 0 0.688z"></path></svg>',
        'ok' => '<svg width="20" height="32" version="1.1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 32"><path class="st0" d="M0.3,17.2c-0.8,1.6,0.1,2.4,2.2,3.7c1.8,1.1,4.3,1.5,5.9,1.7c-0.7,0.6,2.3-2.3-6.3,6.1c-1.8,1.8,1.1,4.6,2.9,2.9l5-4.8c1.9,1.8,3.7,3.6,5,4.8c1.8,1.7,4.8-1.1,3-2.9c-0.1-0.1-6.7-6.4-6.3-6.1c1.6-0.2,4.1-0.6,5.8-1.7l0,0c2.1-1.3,3-2.1,2.2-3.7c-0.5-0.9-1.8-1.7-3.5-0.4c0,0-2.4,1.8-6.2,1.8c-3.8,0-6.2-1.8-6.2-1.8C2.1,15.5,0.8,16.3,0.3,17.2L0.3,17.2z"/><path class="st0" d="M10,16.2c4.6,0,8.4-3.6,8.4-8.1C18.4,3.6,14.6,0,10,0C5.4,0,1.6,3.6,1.6,8.1C1.6,12.6,5.4,16.2,10,16.2z M10,4.1c2.3,0,4.1,1.8,4.1,4c0,2.2-1.9,4-4.1,4s-4.1-1.8-4.1-4C5.9,5.9,7.7,4.1,10,4.1L10,4.1z"/></svg>',
        'whatsapp' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M27.313 4.625c-3-3-7-4.625-11.25-4.625-8.75 0-15.875 7.125-15.875 15.875 0 2.75 0.75 5.5 2.125 7.938l-2.25 8.188 8.438-2.188c2.313 1.25 4.875 1.938 7.563 1.938v0c0 0 0 0 0 0 8.75 0 15.875-7.125 15.875-15.875 0-4.25-1.625-8.25-4.625-11.25zM16.063 29.063v0c-2.375 0-4.688-0.625-6.688-1.875l-0.5-0.25-5 1.313 1.313-4.875-0.313-0.5c-1.313-2.125-2-4.5-2-7 0-7.313 5.938-13.188 13.188-13.188 3.5 0 6.813 1.375 9.313 3.875s3.875 5.813 3.875 9.313c0 7.25-5.938 13.188-13.188 13.188zM23.313 19.188c-0.438-0.188-2.375-1.188-2.75-1.313-0.313-0.125-0.625-0.188-0.875 0.188-0.25 0.438-1 1.313-1.25 1.563s-0.438 0.313-0.875 0.125c-0.375-0.188-1.625-0.625-3.188-2-1.125-1-1.938-2.313-2.188-2.75-0.25-0.375 0-0.563 0.188-0.813 0.188-0.125 0.375-0.438 0.563-0.688 0.25-0.188 0.313-0.375 0.438-0.625s0.063-0.5-0.063-0.688c-0.063-0.188-0.875-2.188-1.188-2.938-0.375-0.813-0.688-0.688-0.938-0.688-0.188 0-0.5 0-0.75 0s-0.688 0.063-1.063 0.438c-0.375 0.438-1.375 1.375-1.375 3.313 0 2 1.438 3.875 1.625 4.125s2.813 4.25 6.75 6c0.938 0.375 1.688 0.625 2.25 0.813 1 0.313 1.813 0.25 2.5 0.188 0.813-0.125 2.375-1 2.688-1.938 0.375-0.875 0.375-1.688 0.25-1.875-0.125-0.125-0.375-0.25-0.75-0.438z"></path></svg>',
        'meneame' => '<svg height="32" viewBox="0 0 32 32" width="32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M49.481,45.874c-2.066,1.283-4.135,2.01-6.312,2.467c-3.193,0.671-6.396,0.671-9.586,0.059c-2.756-0.528-5.017-2.016-6.841-4.089c-3.615-4.108-6.22-8.751-6.991-14.257c-1.057-7.544,1.588-13.655,7.375-18.45c4.152-3.44,9.083-5.107,14.32-6.037c8.217-1.457,15.988,0.141,23.509,3.394c3.861,1.671,7.593,3.647,11.581,5.026c0.88,0.305,1.771,0.58,2.697,0.711c1.671,0.234,3.04-0.332,4.141-1.574c1.438-1.625,1.944-3.58,1.94-5.707c0.404-0.023,0.488,0.293,0.617,0.531c1.227,2.254,0.877,5.921-0.788,7.83c-1.742,2-4.059,2.356-6.521,2.071c-2.798-0.323-5.457-1.14-8.008-2.355c-4.793-2.285-9.655-4.394-14.863-5.573c-6.52-1.477-12.988-1.217-19.317,0.885c-9.215,3.061-14.059,12.217-11.55,21.614c1.447,5.423,4.497,9.694,9.261,12.714c2.061,1.307,4.333,1.717,6.73,1.686c2.426-0.035,4.79-0.508,7.159-0.956C48.444,45.785,48.844,45.683,49.481,45.874z"/><path d="M59.172,92.101c-0.442-0.148-1.268,0.346-1.399-0.271c-0.129-0.603,0.733-0.801,1.234-1.011c3.056-1.271,6.137-2.485,9.194-3.754c1.903-0.79,3.76-1.683,5.469-2.849c0.587-0.401,1.127-0.857,1.603-1.388c0.756-0.843,0.938-1.732,0.497-2.839c-2.325-5.822-4.921-11.54-6.959-17.478c-1.643-4.788-2.946-9.643-3.293-14.735c-0.408-6.007,1.672-10.678,6.856-13.893c2.443-1.518,5.067-2.649,7.694-3.785c3.248-1.404,6.463-2.844,9.312-5.02c4.264-3.252,5.664-7.613,5.299-12.758c-0.164-2.316-0.551-4.591-1.08-6.848c-0.061-0.256-0.409-0.634,0.052-0.832c0.415-0.18,0.636,0.143,0.815,0.472c1.388,2.523,2.473,5.141,2.812,8.04c0.655,5.577-1.785,9.83-5.644,13.51c-2.462,2.348-5.485,3.801-8.467,5.316c-2.693,1.369-5.473,2.58-8.01,4.243c-2.766,1.812-5.058,4.019-5.819,7.388c-0.62,2.74-0.117,5.451,0.435,8.134c1.214,5.899,3.603,11.394,5.962,16.893c1.22,2.837,2.52,5.641,3.49,8.574c1.565,4.729,0.259,8.376-3.95,11.032c-3.027,1.908-6.42,2.743-9.9,3.298C63.339,91.863,61.282,91.964,59.172,92.101z"/><path d="M18.435,35.377c-0.075,0.492-0.354,0.866-0.621,1.247c-4.5,6.421-8.355,13.191-11.262,20.491c-2.025,5.087-2.511,10.282-1.174,15.597c1.655,6.575,6.033,10.635,12.205,13.022c4.475,1.73,9.14,2.562,13.873,3.119c6.577,0.778,13.18,1.297,19.771,1.937c0.634,0.061,1.261,0.236,1.88,0.403c0.298,0.08,0.683,0.202,0.642,0.605c-0.05,0.467-0.482,0.327-0.774,0.351c-4.267,0.347-8.54,0.54-12.821,0.604c-6.023,0.09-12.067,0.132-18.007-0.869c-9.651-1.626-17.131-6.43-20.761-15.91c-1.946-5.087-1.701-10.386-0.134-15.552c2.351-7.75,5.908-14.862,11.699-20.686c1.5-1.507,3.19-2.803,4.844-4.135C17.956,35.474,18.105,35.271,18.435,35.377z"/><path d="M34.902,70.655c6.825-1.119,13.637-1.732,20.499-0.911c3.269,0.393,3.89,1.062,3.966,4.359c0.123,5.218-0.606,10.335-2.086,15.341c-0.247,0.833-0.553,1.653-1.07,2.365c-0.204,0.281-0.431,0.635-0.85,0.488c-0.37-0.129-0.32-0.521-0.336-0.834c-0.1-2.23,0.265-4.429,0.471-6.639c0.295-3.165,0.825-6.315,0.533-9.521c-0.093-1.014-0.558-1.631-1.458-2.063c-2.661-1.275-5.516-1.69-8.401-1.974c-3.526-0.343-7.072-0.31-10.605-0.521C35.342,70.732,35.124,70.686,34.902,70.655z"/></svg>',
        'blogger' => '<svg height="32" viewBox="0 0 32 32" width="32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="m5.945 23.872c.793.145 10.57.177 11.572.042 1.741-.235 3.108-.937 4.388-2.245.927-.949 1.505-1.972 1.886-3.328.263-.943.241-7.652.134-8.129l-.001.001c-.096-.429-.365-.825-.67-.991-.096-.054-.696-.118-1.339-.145-1.077-.048-1.194-.07-1.537-.268-.541-.317-.686-.66-.692-1.581-.006-1.769-.739-3.414-2.191-4.893-1.034-1.055-2.191-1.769-3.509-2.17-.317-.096-1.023-.129-3.391-.155-3.718-.042-4.543.032-5.807.536-2.33.921-4.003 2.883-4.613 5.391-.112.471-.139 1.227-.166 5.567-.032 5.439.006 6.237.343 7.314.835 2.659 3.209 4.625 5.593 5.054zm11.262-8.471c.648.606.509 1.671-.263 2.112v-.001l-.798.129c-2.333.007-8.517.165-9.022-.059-.381-.166-.74-.627-.798-1.039-.059-.391.139-.927.439-1.2.381-.343.546-.353 5.213-.359 4.8-.007 4.774-.007 5.229.417zm-10.54-8.594.001-.002c.418-.423.536-.439 3.15-.439 2.352 0 2.432.006 2.775.182.498.251.718.606.718 1.174 0 .509-.203.868-.659 1.158-.247.155-.391.166-2.695.177-1.421.011-2.557-.021-2.722-.064-.89-.251-1.222-1.527-.568-2.186z"/></svg>',
        'amazon' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M27.696 26.643c0.536-0.268 0.946 0.143 0.393 0.857s-5 4.786-12.464 4.786-13.179-5.107-14.929-7.214c-0.482-0.554 0.071-0.804 0.393-0.589 5.232 3.179 13.411 8.411 26.607 2.161zM31.393 24.589c0.268 0.357 0 1.929-0.464 3.071-0.464 1.125-1.143 1.911-1.518 2.214-0.393 0.321-0.679 0.196-0.464-0.268s1.375-3.321 0.911-3.929c-0.464-0.589-2.643-0.304-3.429-0.232-0.768 0.071-0.929 0.143-1-0.018-0.161-0.411 1.554-1.107 2.679-1.25 1.125-0.125 2.929-0.054 3.286 0.411zM24.357 16.679c0 1.964 2.304 3.768 2.304 3.768l-4.054 4c-1.589-1.5-2.786-2.75-2.786-2.75-0.179-0.179-0.321-0.393-0.446-0.589-3.232 5.054-13.107 4.732-13.107-3.089 0-7.286 8.625-8.268 12.107-8.393v-2.268c0-0.482 0.179-2.679-2.536-2.679 0 0-2.714 0-3.875 3.536l-5.25-0.482c0-3.518 3.339-7.446 9.625-7.446 6.268 0 8.018 4.071 8.018 5.875v10.518zM12.357 17.054c0 3.625 6.018 4.482 6.018-1.232v-2.893c-2.411 0.071-6.018 0.75-6.018 4.125z"/></svg>',
        'gmail' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32"><path d="M28.7,4c-0.1,0-0.3,0-0.4,0.1l-12.3,9l-12.3-9C3.6,4,3.5,4,3.3,4C1.5,4,0,5.5,0,7.3v17.3C0,26.5,1.5,28,3.3,28h1.3c0.4,0,0.7-0.3,0.7-0.7V12l10.3,7.3c0.2,0.2,0.5,0.2,0.8,0L26.7,12v15.4c0,0.4,0.3,0.7,0.7,0.7h1.3c1.8,0,3.3-1.5,3.3-3.3V7.3C32,5.5,30.5,4,28.7,4z"/></svg>',
        'aol' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M17.4,12.4c3.4,0,5,2.7,5,4.9c0,2.3-1.6,4.9-5,4.9c-3.4,0-5-2.7-5-4.9C12.4,15.1,14.1,12.4,17.4,12.4 M17.4,19.7c1.2,0,2.2-1,2.2-2.3c0-1.4-1-2.3-2.2-2.3c-1.2,0-2.2,1-2.2,2.3C15.2,18.7,16.2,19.7,17.4,19.7 M24,9.7h2.8v12.4H24V9.7z M30.1,18.4c-1,0-1.9,0.8-1.9,1.9c0,1,0.8,1.9,1.9,1.9c1,0,1.9-0.8,1.9-1.9C32,19.3,31.2,18.4,30.1,18.4 M7.4,9.7H4.9L0,22.1h3.3L4,20.3h4.3l0.6,1.8h3.3L7.4,9.7z M4.8,17.8l1.3-4.3l1.3,4.3L4.8,17.8L4.8,17.8z"/></svg>',
        'newsvine' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M17.125 27.375l2.75-2c0-0.125 0-0.188 0-0.25 0-1.25 1-2.313 2.25-2.313s2.313 1.063 2.313 2.313c0 1.25-1.063 2.25-2.313 2.25-0.438 0-0.875-0.125-1.188-0.375l-3.813 2.75v2.25h-2.25v-6.75l-3.875-2.813c-0.375 0.188-0.75 0.313-1.125 0.313-1.25 0-2.313-1.063-2.313-2.313s1.063-2.25 2.313-2.25c1.25 0 2.25 1 2.25 2.25 0 0.125 0 0.25-0.063 0.375l2.813 2.063v-6.75l-3.875-2.813c-0.375 0.188-0.75 0.313-1.125 0.313-1.25 0-2.313-1.063-2.313-2.313s1.063-2.25 2.313-2.25c1.25 0 2.25 1 2.25 2.25 0 0.125 0 0.313-0.063 0.438l2.813 2v-6.313l-3.938-2.875c-0.313 0.188-0.688 0.313-1.063 0.313-1.25 0-2.313-1-2.313-2.25s1.063-2.313 2.313-2.313c1.25 0 2.25 1.063 2.25 2.313 0 0.125 0 0.25-0.063 0.375l2.813 2.063v-5.063h2.25v9.563l2.75-2c0-0.125 0-0.25 0-0.313 0-1.25 1-2.313 2.25-2.313s2.313 1.063 2.313 2.313c0 1.25-1.063 2.25-2.313 2.25-0.438 0-0.813-0.125-1.188-0.313l-3.813 2.75v6.313l2.75-2c0-0.125 0-0.188 0-0.25 0-1.313 1-2.313 2.25-2.313s2.313 1 2.313 2.313c0 1.25-1.063 2.25-2.313 2.25-0.438 0-0.813-0.125-1.188-0.375l-3.813 2.813v6.688z"/></svg>',
        'hackernews' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32"><path d="M22,0c-1.2,2.1-5.7,9.8-5.7,9.8h-0.1c0,0-4.3-7.7-5.6-9.8H3.3l9.6,15.5V32h6.4V15.5L28.7,0H22z"/></svg>',
        'evernote' => '<svg height="32" viewBox="0 0 32 32" width="32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="m2.795 6.727c.415-.171.459-.18 1.883-.18 2.924-.018 3.563.302 3.608-1.155 0-4.162-.041-4.033.175-4.576.088-.179-.204.193-5.685 5.891-.02.02-.02.039.019.02z"/><path d="m2.582 12.338c.504 2.288 1.475 3.104 1.475 3.104 1.912 2.015 5.2 2.403 6.344 1.81 1.203-.756 1.804-3.541 1.804-3.541.137 1.85 2.174 2.506 2.989 2.606.101.015.326.04.582.099 2.564.661 2.518 3.077 2.483 2.977 0 2.07-2.439 3.179-3.705 1.879-.395-.404-.448-1.073.039-1.473.241-.219.682-.161.969-.338l.004-.002c.479-.273.471-.874.442-.774 0-1.778-3.819-.816-3.822 2.109v.001c.01 4.278 8.498 5.069 9.546-2.627.058 0 .776-6.288-.408-12.775-.503-2.726-3.143-2.905-4.21-3.104-1.126-.199-3.357-.597-3.357-.597s-.252-1.234-1.435-1.532c-.792-.204-.815-.142-1.63-.16-.95 0-1.592.617-1.687 1.354-.063 4.163.206 4.919-.408 5.511-.743.705-1.895.298-5.278.419-.737.099-1.319.755-1.319 1.73.091 1.156.406 2.477.582 3.324zm14.046-1.413c.429-1.095 2.433-.856 2.562.318 0 .101.037.359-.137.359-.323.051-2.385-.1-2.483-.399-.019-.059.019-.178.058-.278z"/></svg>',
        'myspace' => '<svg height="32" viewBox="0 0 32 32" width="32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="m15 18.75c0 .414.336.75.75.75h7.5c.414 0 .75-.336.75-.75v-.75c0-2.481-2.019-4.5-4.5-4.5s-4.5 2.019-4.5 4.5z"/><circle cx="19.5" cy="8.25" r="3.75"/><path d="m6.75 18.75c0 .414.336.75.75.75h6c.414 0 .75-.336.75-.75v-1.5c0-2.069-1.683-3.75-3.75-3.75s-3.75 1.681-3.75 3.75z"/><path d="m.75 19.5h4.5c.414 0 .75-.336.75-.75v-2.25c0-1.654-1.346-3-3-3-1.655 0-3 1.346-3 3v2.25c0 .414.336.75.75.75z"/><circle cx="10.5" cy="9" r="3.375"/><circle cx="3" cy="9.75" r="2.625"/></svg>',
        'mailru' => '<svg height="32" viewBox="0 0 32 32" width="32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M20.8,16c0,2.7-2.2,4.8-4.8,4.8s-4.8-2.2-4.8-4.8s2.2-4.8,4.8-4.8S20.8,13.3,20.8,16 M16,0C7.2,0,0,7.2,0,16s7.2,16,16,16c3.2,0,6.3-1,9-2.8l0.1,0l-2.2-2.5l0,0c-2.1,1.3-4.4,2-6.9,2C9,28.7,3.3,23,3.3,16S9,3.3,16,3.3S28.7,9,28.7,16c0,0.9-0.1,1.8-0.3,2.7c-0.4,1.7-1.6,2.2-2.4,2.1c-0.9-0.1-1.9-0.7-1.9-2.2V16c0-4.5-3.6-8.1-8.1-8.1S7.9,11.5,7.9,16s3.6,8.1,8.1,8.1c2.2,0,4.2-0.9,5.7-2.4c0.9,1.4,2.3,2.3,4,2.4c0.1,0,0.3,0,0.4,0c1.2,0,2.3-0.4,3.2-1.1c1-0.7,1.7-1.8,2.1-3c0.1-0.2,0.2-0.7,0.2-0.7v0c0.2-1,0.3-2,0.3-3.3C32,7.2,24.8,0,16,0"/></svg>',
        'viadeo' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32"><path d="M24,16.1c0-0.1,0-0.1-0.1-0.2c-0.3,0.2-0.6,0.3-0.9,0.4c-0.3,0.1-0.6,0.2-0.9,0.3c-0.3,0.1-0.6,0.2-0.9,0.3c0,0,0,0,0,0.1c0,0,0,0.1,0,0.1c0.4,1.1,0.6,2.2,0.6,3.3c0,0.9-0.1,1.9-0.4,2.8c-0.4,1.4-1.1,2.6-2.1,3.6c-1.4,1.5-3.2,2.3-5.3,2.5c-0.2,0-0.4,0-0.6,0c0,0,0-0.1,0-0.1c0.1-0.1,0.2-0.2,0.3-0.2c2.2-1.6,3.8-3.6,5-6.1c1-2,1.5-4.2,1.6-6.4c0-1.1-0.1-2.2-0.3-3.3c-0.2-1.2-0.6-2.4-1-3.6c0,0-0.1-0.1-0.1-0.2c0-0.2,0-0.3,0-0.3c0,0,0-0.1,0-0.1c-0.1-1-0.3-2-0.6-3c-0.4-1.3-0.9-2.6-1.7-3.8c-0.5-0.8-1.1-1.5-1.8-2.2C15.1,0.1,15,0.1,14.9,0c0,0,0,0.1,0,0.1C15,0.2,15,0.3,15.1,0.4c1.3,2.2,2.4,4.4,3.3,6.8c0.3,0.6,0.5,1.3,0.7,1.9l0.1,0.1c0,0,0,0.1,0,0.3c0,0.3,0,0.7,0,1c0,1.8,0,3.5-0.2,5.3c-0.1,0.8-0.2,1.6-0.3,2.4c-0.2,1-0.4,2-0.7,3c-0.4,1.2-0.8,2.4-1.4,3.5c-0.5,1-1.2,1.9-2,2.7c-0.7,0.7-1.6,1.3-2.6,1.7c-0.1,0-0.2,0.1-0.3,0c-1.3-0.3-2.5-0.8-3.5-1.6c-0.9-0.7-1.6-1.6-2.2-2.6c-0.6-1.1-0.9-2.2-1.1-3.4C5,20.8,5,20,5.1,19.3c0.1-0.9,0.3-1.7,0.7-2.5c0.5-1.2,1.3-2.2,2.3-3.1c0.8-0.7,1.6-1.2,2.5-1.6c0.6-0.2,1.2-0.4,1.9-0.5c0.6-0.1,1.2-0.1,1.7,0c0.7,0.1,1.5,0.2,2.1,0.5c0.1,0,0.1,0,0.2,0.1c0.1-0.5,0.2-0.9,0.3-1.4c0.1-0.4,0.3-0.9,0.5-1.3c-0.1-0.1-0.2-0.1-0.3-0.1c-0.9-0.3-1.9-0.5-2.9-0.5c-1-0.1-2.1,0-3.1,0.2c-1.2,0.2-2.4,0.7-3.4,1.4c-1,0.6-1.9,1.4-2.7,2.3c-1.7,2-2.6,4.4-2.8,7c0,0.8,0,1.5,0.1,2.3c0.1,1.1,0.4,2.1,0.8,3.1c0.7,1.6,1.7,3,3,4.1c0.9,0.9,2,1.5,3.2,2c1.1,0.4,2.3,0.6,3.5,0.7c1.1,0.1,2.2,0,3.3-0.2c1.5-0.3,2.8-0.9,4-1.8c0.9-0.7,1.7-1.5,2.4-2.5c1.4-1.9,2.1-4,2.3-6.3c0.1-0.9,0-1.9-0.1-2.8C24.5,17.6,24.3,16.8,24,16.1z"/><path d="M29.4,3.6c-0.2-0.9-0.6-1.8-1-2.6c-0.1-0.1-0.1-0.2-0.2-0.4C28.1,0.8,28,0.9,28,1c-0.3,0.6-0.7,1.2-1.2,1.6c-0.8,0.7-1.6,1.3-2.6,1.5c-0.1,0-0.2,0-0.3,0.1c-0.8,0.2-1.5,0.5-2.2,0.9c-0.5,0.3-0.9,0.6-1.2,1c-0.6,0.8-0.9,1.7-0.9,2.7c0,0.8,0.3,1.6,0.7,2.3c0,0,0,0.1,0.1,0.1c3.2-0.8,5.7-2.6,7.4-5.6c0,0.1,0,0.1,0,0.2c-0.1,0.3-0.1,0.5-0.3,0.7c-0.3,0.5-0.6,1-1,1.4c-0.7,0.7-1.4,1.4-2.2,2c-1,0.7-1.9,1.4-3,2c-0.1,0-0.2,0.1-0.2,0.2c0.1,0.1,0.3,0.3,0.4,0.4c0.5,0.4,1.1,0.8,1.8,1c0.6,0.2,1.3,0.3,1.9,0.1c0.8-0.1,1.5-0.5,2.1-1c0.6-0.5,1-1.1,1.4-1.8c0.2-0.4,0.4-0.8,0.6-1.2c0.3-0.9,0.5-1.8,0.5-2.7C29.8,5.9,29.7,4.7,29.4,3.6z"/></svg>',
        'line' => '<svg height="32" viewBox="0 0 32 32" width="32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="m12 .5c-6.615 0-12 4.398-12 9.803 0 4.841 4.27 8.897 10.035 9.668.391.083.923.26 1.058.594.12.303.079.771.038 1.087l-.164 1.026c-.045.303-.24 1.193 1.049.649 1.291-.542 6.916-4.104 9.436-7.019 1.724-1.9 2.548-3.847 2.548-6.005 0-5.405-5.385-9.803-12-9.803zm-4.697 13.017h-2.386c-.345 0-.63-.287-.63-.633v-4.801c0-.347.285-.634.63-.634.348 0 .63.287.63.634v4.167h1.756c.348 0 .629.285.629.634 0 .346-.282.633-.629.633zm2.466-.633c0 .346-.282.633-.631.633-.345 0-.627-.287-.627-.633v-4.801c0-.347.282-.634.63-.634.346 0 .628.287.628.634zm5.741 0c0 .272-.174.513-.432.6-.064.021-.133.031-.199.031-.211 0-.391-.091-.51-.252l-2.443-3.338v2.958c0 .346-.279.633-.631.633-.346 0-.626-.287-.626-.633v-4.8c0-.272.173-.513.43-.599.06-.023.136-.033.194-.033.195 0 .375.105.495.256l2.462 3.351v-2.975c0-.347.282-.634.63-.634.345 0 .63.287.63.634zm3.855-3.035c.349 0 .63.287.63.635 0 .347-.281.634-.63.634h-1.755v1.132h1.755c.349 0 .63.285.63.634 0 .346-.281.633-.63.633h-2.386c-.345 0-.627-.287-.627-.633v-4.801c0-.347.282-.634.63-.634h2.386c.346 0 .627.287.627.634 0 .351-.281.634-.63.634h-1.755v1.132z"/></svg>',
        'flipboard' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M4.313 2.313v23.375h7.813v-7.813h7.75v-7.75h7.813v-7.813z"></path></svg>',
        'comments' => '<svg width="38" height="32" viewBox="0 0 38 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M37.7,13.3c0,2.4-0.8,4.7-2.5,6.7s-3.9,3.6-6.8,4.8c-2.9,1.2-6.1,1.8-9.4,1.8c-0.9,0-2-0.1-3-0.1c-2.8,2.4-6,4.1-9.6,5c-0.7,0.1-1.5,0.3-2.3,0.4c-0.3,0-0.5,0-0.7-0.2c-0.2-0.1-0.3-0.3-0.4-0.6l0,0C3,31.1,3,31.1,3,30.9c0-0.1,0-0.1,0-0.1c0-0.1,0.1-0.1,0.1-0.2l0.1-0.2l0.1-0.1L3.6,30c0.1-0.1,0.3-0.4,0.6-0.7c0.4-0.4,0.6-0.6,0.7-0.7c0.1-0.2,0.4-0.4,0.7-0.9c0.3-0.4,0.5-0.7,0.7-1c0.2-0.4,0.4-0.7,0.6-1.2c0.2-0.5,0.4-1,0.6-1.6c-2.2-1.2-3.9-2.8-5.2-4.6s-1.9-3.7-1.9-5.8c0-1.8,0.5-3.5,1.5-5.2c1-1.7,2.3-3.1,4-4.2c1.7-1.2,3.6-2.2,6-2.8C14,0.4,16.4,0,19,0c3.4,0,6.5,0.6,9.4,1.8c2.8,1.2,5.1,2.8,6.8,4.8S37.7,10.9,37.7,13.3z"/></svg>',
        'yummly' => '<svg width="49" height="32" viewBox="0 0 49 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M4.576 0.128c-0.032 0.032-0.16 0.064-0.32 0.064-0.576 0.096-1.216 0.288-1.376 0.384-0.064 0.064-0.128 0.064-0.16 0.032s-0.032 0-0.032 0.064c0 0.064-0.032 0.064-0.064 0.064-0.096-0.096-1.504 0.672-1.888 1.024-0.16 0.16-0.32 0.288-0.32 0.256s-0.096 0.096-0.192 0.288c-0.16 0.256-0.192 0.416-0.192 0.672 0.032 0.224 0.096 0.448 0.16 0.512 0.032 0.064 0.064 0.096 0.032 0.096-0.096 0 0.064 0.288 0.384 0.768 0.16 0.224 0.32 0.416 0.384 0.416 0.032 0 0.096 0.032 0.064 0.064-0.032 0.128 0.384 0.416 0.576 0.416 0.128 0 0.32-0.128 0.544-0.32 0.16-0.192 0.352-0.32 0.352-0.32 0.032 0 0.192-0.096 0.384-0.224 0.704-0.48 1.6-0.608 1.856-0.288 0.064 0.064 0.16 0.128 0.192 0.096 0.064-0.032 0.064-0.032 0.032 0.032s-0.032 0.192 0 0.288c0.032 0.096 0.032 0.352 0 0.576-0.032 0.192-0.096 0.48-0.096 0.576-0.032 0.128-0.096 0.384-0.16 0.544-0.032 0.192-0.096 0.384-0.096 0.448-0.032 0.032-0.096 0.288-0.16 0.544-0.096 0.256-0.16 0.576-0.192 0.704s-0.064 0.256-0.064 0.288c-0.064 0.064-0.128 0.352-0.16 0.672-0.032 0.064-0.064 0.16-0.064 0.256-0.064 0.16-0.256 0.832-0.288 0.992 0 0.064-0.032 0.192-0.064 0.256-0.064 0.128-0.224 0.8-0.256 0.992-0.032 0.064-0.16 0.576-0.288 1.088-0.16 0.512-0.288 1.024-0.288 1.088-0.032 0.096-0.096 0.288-0.128 0.448-0.064 0.192-0.064 0.352-0.064 0.384 0.032 0.032 0.032 0.096-0.032 0.096-0.096 0.032-0.224 0.96-0.192 1.632 0 0.544 0.32 1.696 0.448 1.696 0.032 0 0.096 0.064 0.128 0.16 0.064 0.224 0.64 0.768 1.024 0.992 0.96 0.544 2.752 0.608 4.512 0.224 0.736-0.16 1.888-0.544 1.92-0.64 0-0.032 0.064-0.064 0.096-0.032 0.064 0.064 1.088-0.448 1.312-0.64 0.064-0.032 0.128-0.064 0.16-0.032 0.032 0-0.032 0.416-0.128 0.864-0.096 0.48-0.16 0.896-0.16 0.928 0 0.064-0.032 0.224-0.16 0.672 0 0.096-0.096 0.16-0.16 0.16-0.576 0-2.688 0.512-2.688 0.608 0 0.064-0.032 0.064-0.096 0.032s-1.184 0.384-1.28 0.512c-0.032 0.032-0.064 0.064-0.064 0s-0.672 0.288-0.768 0.384c0 0.032-0.064 0.096-0.096 0.096-0.16 0-0.704 0.352-0.672 0.416s0.032 0.064-0.032 0.032c-0.16-0.096-1.856 1.664-1.696 1.824 0.032 0.032 0 0.032-0.064 0.032-0.128 0-0.832 1.472-0.96 2.112-0.032 0.096-0.128 0.992-0.16 1.216-0.032 0.544 0.128 1.344 0.384 1.92 0.864 1.824 3.040 2.688 5.44 2.176 0.512-0.128 1.568-0.512 1.696-0.64 0.064-0.064 0.16-0.128 0.16-0.096 0.064 0.032 0.192 0 0.32-0.128 0.096-0.096 0.256-0.224 0.352-0.288 0.192-0.128 0.736-0.64 1.088-1.024 0.32-0.352 0.768-1.024 0.736-1.088-0.032-0.032-0.032-0.064 0.032-0.064s0.352-0.512 0.352-0.608c0-0.032 0.032-0.096 0.064-0.128 0.192-0.128 0.832-1.888 1.088-3.008 0.16-0.64 0.32-1.184 0.352-1.248 0.064-0.16 0.384-0.16 1.984 0.032 0.992 0.128 1.152 0.128 1.344 0.16 0.128 0.032 0.544 0.096 0.96 0.192 1.12 0.16 0.992 0.16 2.88 0.544 0.736 0.128 1.376 0.256 1.472 0.288 0.064 0 0.192 0.032 0.288 0.064 0.064 0.032 0.224 0.064 0.352 0.064 0.192 0.032 0.832 0.16 0.896 0.192 0.032 0 0.16 0.032 0.256 0.064 0.224 0.064 2.432 0.512 2.752 0.608 0.128 0 0.512 0.096 0.864 0.16 0.8 0.16 1.12 0.224 1.376 0.256 0.096 0 0.192 0.032 0.192 0.032 0 0.032 0.064 0.064 0.096 0.064 0.128 0 0.768 0.096 1.024 0.16 0.704 0.128 2.144 0.352 2.528 0.416 0.288 0.032 0.512 0.064 0.544 0.096 0.032 0 0.32 0.032 0.672 0.064 0.32 0.032 0.672 0.064 0.768 0.096 0.704 0.128 5.152 0.224 5.984 0.096 0.224-0.032 0.608-0.064 0.896-0.096s0.544-0.128 0.576-0.16c0.032-0.032 0.064-0.032 0.096-0.032 0.256 0.16 3.616-0.992 3.616-1.216 0-0.032 0.032-0.064 0.064-0.064 0.096 0.032 0.576-0.224 1.024-0.544 0.512-0.384 0.768-0.896 0.768-1.504 0-0.544-0.288-1.248-0.672-1.76-0.288-0.416-0.608-0.736-0.608-0.64 0 0.032-0.032 0-0.096-0.032-0.064-0.064-0.352 0.032-1.056 0.384-0.544 0.256-1.12 0.512-1.28 0.576s-0.416 0.16-0.544 0.224c-0.32 0.16-2.336 0.672-2.816 0.736-0.192 0.032-0.448 0.064-0.544 0.096-0.128 0-0.448 0.032-0.768 0.064-0.288 0.064-0.672 0.096-0.832 0.096-0.448 0.064-3.904 0.064-4.512 0-0.288 0-0.768-0.064-1.056-0.096-0.416-0.032-0.768-0.064-1.664-0.16-0.128 0-0.384-0.032-0.576-0.064-1.152-0.16-1.792-0.256-1.952-0.256-0.128-0.032-0.224-0.032-0.224-0.032 0-0.032-0.16-0.064-0.704-0.128-0.224-0.032-0.48-0.064-0.576-0.096-0.128-0.032-0.448-0.096-0.768-0.128-0.288-0.064-0.64-0.128-0.736-0.128-0.128-0.032-0.32-0.064-0.416-0.064-0.256-0.064-2.048-0.384-2.368-0.448-0.192-0.032-0.736-0.128-1.024-0.16-0.096 0-0.16-0.032-0.16-0.032 0-0.032-0.224-0.064-0.672-0.128-0.192 0-0.416-0.064-0.512-0.064-0.096-0.032-0.32-0.064-0.544-0.096-0.192-0.032-0.448-0.096-0.544-0.096-0.096-0.032-0.32-0.064-0.512-0.064-0.16-0.032-0.384-0.064-0.48-0.064-0.096-0.032-0.416-0.096-0.672-0.128-0.288-0.032-0.576-0.064-0.672-0.064-0.096-0.032-0.384-0.064-0.64-0.096-0.224-0.032-0.544-0.064-0.704-0.064-0.48-0.064-1.568-0.16-1.76-0.16-0.16 0.032-0.16 0-0.064-0.512 0.064-0.288 0.128-0.672 0.16-0.896 0.128-0.768 0.256-1.6 0.32-1.92 0.032-0.096 0.096-0.352 0.096-0.48 0.032-0.16 0.096-0.512 0.128-0.736 0.064-0.224 0.096-0.544 0.128-0.704 0-0.128 0.064-0.32 0.064-0.416 0.032-0.064 0.064-0.288 0.096-0.512 0.032-0.192 0.064-0.416 0.096-0.48 0-0.064 0.032-0.256 0.064-0.416s0.064-0.384 0.096-0.512c0.032-0.192 0.128-0.704 0.16-1.056 0.032-0.128 0.064-0.352 0.16-0.832 0.032-0.096 0.064-0.32 0.096-0.544 0.032-0.192 0.064-0.448 0.096-0.544 0.032-0.224 0.096-0.544 0.16-0.896 0.032-0.128 0.096-0.576 0.16-0.928 0.064-0.384 0.128-0.8 0.16-0.96s0.096-0.576 0.16-0.896c0.096-0.32 0.16-0.768 0.16-0.96 0.032-0.224 0.064-0.416 0.096-0.48 0.032-0.032 0.064-0.224 0.096-0.448 0-0.192 0.064-0.416 0.064-0.48 0.032-0.064 0.064-0.288 0.096-0.48 0-0.192 0.032-0.384 0.064-0.416 0.096-0.128 0.16-1.152 0.096-1.536-0.032-0.224-0.128-0.48-0.192-0.544-0.096-0.096-0.16-0.192-0.128-0.224 0.032 0-0.128-0.128-0.32-0.224-0.672-0.352-2.176-0.288-2.912 0.128-0.256 0.16-0.288 0.192-0.256 0.512 0.064 0.832 0.032 1.728-0.096 2.496-0.096 0.448-0.16 0.896-0.192 0.96 0 0.064-0.032 0.288-0.064 0.448-0.032 0.192-0.096 0.416-0.096 0.512-0.032 0.096-0.064 0.256-0.064 0.384-0.032 0.096-0.064 0.32-0.096 0.48s-0.128 0.8-0.256 1.376c-0.096 0.608-0.224 1.248-0.224 1.408-0.032 0.16-0.096 0.48-0.16 0.736-0.032 0.256-0.096 0.544-0.128 0.672 0 0.128-0.032 0.352-0.064 0.512s-0.16 0.768-0.256 1.376c-0.128 0.608-0.192 1.152-0.192 1.184 0 0.096-0.768 0.544-1.312 0.736-0.192 0.064-0.384 0.16-0.384 0.224s0 0.064-0.032 0.032-0.352 0.064-0.736 0.192c-1.632 0.544-3.008 0.608-3.488 0.128-0.192-0.192-0.192-0.256-0.192-0.928 0-0.736 0.032-0.896 0.992-4.448 0.064-0.256 0.096-0.512 0.064-0.512 0-0.032 0.032-0.096 0.064-0.096 0.032-0.032 0.096-0.16 0.128-0.288 0-0.128 0.032-0.256 0.032-0.256 0.032 0 0.064-0.128 0.128-0.48 0.096-0.48 0.096-0.512 0.128-0.544 0 0 0.032-0.032 0.032-0.064s0.064-0.224 0.128-0.448c0.064-0.192 0.128-0.448 0.128-0.544s0.032-0.224 0.064-0.288c0.48-1.344 0.48-3.2 0-4.256-0.352-0.8-1.216-1.408-2.208-1.6-0.416-0.064-1.696-0.096-1.76-0.032zM10.944 23.968c-0.032 0.192-0.128 0.416-0.16 0.544s-0.064 0.256-0.064 0.288c0 0.064 0 0.096-0.352 0.96-0.128 0.288-0.224 0.576-0.192 0.576 0.032 0.032 0 0.064-0.064 0.064s-0.224 0.32-0.192 0.448c0 0.032 0 0.032-0.032 0.032-0.064-0.032-0.16 0.064-0.224 0.224-0.192 0.288-0.608 0.704-0.832 0.768-0.064 0.032-0.128 0.064-0.128 0.096 0 0.096-0.064 0.096-0.704 0.128-0.544 0.032-0.736-0.064-0.96-0.512-0.16-0.224-0.128-0.992 0.032-1.408 0.064-0.16 0.128-0.352 0.128-0.416s0.032-0.096 0.064-0.064c0.064 0.032 0.096-0.032 0.128-0.128 0.064-0.192 0.832-0.928 0.992-0.928 0.032 0 0.032-0.032 0-0.064-0.032-0.064 0-0.096 0.032-0.096 0.096 0.064 0.704-0.256 0.8-0.384 0.032-0.032 0.064-0.032 0.064 0s0.064 0 0.16-0.032c0.16-0.096 1.28-0.416 1.472-0.416 0.064 0 0.064 0.096 0.032 0.32zM38.848 5.952c-0.16 0.032-0.384 0.064-0.512 0.096-0.288 0.064-1.44 0.48-1.504 0.576-0.032 0.064-0.064 0.064-0.064 0.032s-0.16 0.032-0.352 0.096c-0.32 0.192-0.576 0.224-0.544 0.128 0-0.128-0.128-0.352-0.256-0.352-0.064 0-0.096-0.032-0.096-0.064 0-0.16-0.608-0.352-1.312-0.384-0.48-0.064-2.048 0.384-1.92 0.512 0.032 0 0 0.096-0.032 0.128-0.064 0.096-0.064 0.224 0 0.448 0.096 0.416 0.096 1.248 0 1.632-0.064 0.16-0.096 0.416-0.128 0.64s-0.032 0.384-0.032 0.384c-0.032 0-0.064 0.16-0.128 0.576-0.032 0.16-0.064 0.384-0.096 0.48-0.032 0.128-0.064 0.32-0.064 0.48-0.032 0.16-0.064 0.384-0.096 0.512-0.064 0.224-0.448 2.496-0.512 2.816-0.032 0.256-0.096 0.576-0.192 1.184-0.064 0.256-0.128 0.608-0.128 0.768-0.032 0.128-0.064 0.384-0.096 0.48-0.288 1.6 0.032 2.368 1.056 2.592 0.48 0.128 1.728 0.032 1.888-0.096 0.032-0.032 0.128-0.064 0.224-0.064 0.064 0 0.128-0.032 0.128-0.096 0-0.032 0.032-0.064 0.064-0.064 0.352 0.064 0.448-0.224 0.32-0.8-0.128-0.544-0.096-0.896 0.096-1.856 0.064-0.416 0.16-0.864 0.16-0.992 0.032-0.128 0.064-0.352 0.096-0.448 0.096-0.544 0.128-0.64 0.16-0.896 0.032-0.128 0.064-0.352 0.064-0.48 0.032-0.16 0.064-0.384 0.096-0.512 0.224-1.152 0.288-1.568 0.256-1.632-0.032-0.032-0.032-0.096 0.032-0.128 0.032 0 0.064-0.128 0.064-0.256s0.064-0.48 0.128-0.736l0.096-0.512 0.576-0.256c0.64-0.32 0.992-0.416 1.44-0.32 0.544 0.096 0.704 0.704 0.512 1.824-0.032 0.192-0.096 0.416-0.096 0.512-0.032 0.096-0.064 0.256-0.064 0.384-0.032 0.096-0.064 0.32-0.096 0.48s-0.096 0.608-0.16 1.024c-0.064 0.384-0.16 0.832-0.16 1.024-0.032 0.16-0.064 0.32-0.096 0.384-0.032 0.032-0.064 0.224-0.096 0.48 0 0.224-0.064 0.48-0.096 0.608-0.224 1.152-0.288 2.112-0.16 2.56 0.128 0.32 0.608 0.8 0.736 0.768 0.064-0.032 0.192 0 0.32 0.064 0.256 0.16 1.376 0.096 1.984-0.096 0.576-0.16 0.8-0.384 0.736-0.672-0.032-0.128-0.096-0.32-0.096-0.448-0.032-0.128-0.064-0.256-0.064-0.288-0.032-0.064 0.032-0.512 0.128-1.024 0.064-0.512 0.16-1.056 0.192-1.216s0.096-0.448 0.128-0.704c0.096-0.448 0.16-0.896 0.192-1.152 0.032-0.096 0.096-0.544 0.16-0.96 0.096-0.448 0.16-0.896 0.192-0.992 0-0.128 0.064-0.352 0.064-0.512 0.032-0.16 0.128-0.544 0.16-0.864l0.096-0.576 0.544-0.288c0.768-0.384 1.344-0.48 1.664-0.288 0.16 0.096 0.32 0.288 0.352 0.416 0.096 0.256 0.032 1.088-0.128 1.984-0.064 0.288-0.096 0.448-0.288 1.664-0.224 1.312-0.256 1.472-0.32 1.792 0 0.16-0.032 0.352-0.064 0.416 0 0.064-0.064 0.256-0.064 0.384-0.032 0.16-0.096 0.416-0.096 0.544-0.224 1.216-0.224 1.76 0 2.24 0.128 0.224 0.288 0.352 0.576 0.512 0.384 0.192 0.512 0.192 1.216 0.192 0.608 0 0.896-0.032 1.28-0.192 0.608-0.224 0.672-0.352 0.544-0.928-0.096-0.512-0.032-1.408 0.192-2.464 0.032-0.224 0.096-0.576 0.128-0.736 0.032-0.192 0.096-0.608 0.16-0.928 0.064-0.288 0.096-0.576 0.096-0.608s0-0.064 0.032-0.096c0.032-0.096 0.064-0.288 0.096-0.672 0.032-0.224 0.096-0.448 0.096-0.512 0.032-0.064 0.064-0.256 0.096-0.416 0-0.16 0.064-0.384 0.064-0.448 0.032-0.128 0.064-0.32 0.096-0.48s0.064-0.352 0.064-0.448c0.224-1.088 0.32-2.272 0.192-2.848-0.096-0.512-0.128-0.576-0.256-0.832-0.416-0.8-1.12-1.184-2.432-1.248-0.608-0.032-2.464 0.448-2.464 0.64 0 0.064 0 0.064-0.032 0.032s-0.384 0.128-0.736 0.32l-0.704 0.352-0.16-0.224c-0.224-0.416-0.608-0.736-1.088-0.896-0.48-0.192-1.504-0.288-1.952-0.16zM21.536 6.048c0 0.032-0.224 0.064-0.48 0.064-0.544 0.064-1.184 0.224-1.184 0.352 0 0.032-0.032 0.032-0.064 0.032-0.032-0.032-0.128 0-0.224 0.096-0.128 0.16-0.128 0.192 0.032 0.832 0.064 0.224 0.032 0.864-0.064 1.376-0.064 0.288-0.128 0.608-0.128 0.768 0 0.128-0.064 0.416-0.128 0.64-0.032 0.224-0.096 0.544-0.128 0.704-0.064 0.544-0.096 0.704-0.16 0.864 0 0.064-0.064 0.32-0.064 0.544-0.032 0.224-0.064 0.416-0.096 0.448 0 0.032-0.064 0.224-0.096 0.48-0.032 0.224-0.064 0.48-0.064 0.544-0.032 0.064-0.064 0.256-0.096 0.416-0.096 0.544-0.128 0.8-0.16 1.024-0.16 0.896-0.096 2.208 0.096 2.624 0.064 0.096 0.128 0.256 0.192 0.384 0.16 0.352 0.704 0.896 1.056 1.024 0.928 0.384 1.664 0.416 2.784 0.128 0.224-0.064 0.416-0.128 0.448-0.128 0.064 0 0.16-0.064 0.256-0.096 0.704-0.288 1.472-0.544 1.504-0.512 0 0 0.064 0.128 0.128 0.256 0.288 0.608 0.896 0.864 1.888 0.864 0.64-0.032 1.536-0.256 1.632-0.416 0.032-0.032 0.096-0.064 0.128-0.096 0.032 0 0.064-0.16 0.064-0.384-0.096-1.248-0.096-1.472-0.032-1.76 0.032-0.16 0.096-0.416 0.128-0.576 0.064-0.576 0.128-0.96 0.16-1.12 0.032-0.096 0.064-0.288 0.096-0.448s0.064-0.384 0.096-0.48c0-0.096 0.032-0.288 0.064-0.448s0.096-0.576 0.16-0.896c0.064-0.288 0.128-0.576 0.096-0.608s0-0.096 0.032-0.16c0.032-0.096 0.096-0.32 0.128-0.512 0.032-0.224 0.064-0.48 0.096-0.608 0.032-0.192 0.32-1.792 0.416-2.272 0-0.16 0.064-0.352 0.064-0.48 0.128-0.448 0.064-1.312-0.096-1.632-0.128-0.288-0.736-0.768-0.832-0.672-0.032 0.032-0.096 0-0.16-0.032-0.096-0.096-1.088-0.128-1.44-0.032-0.448 0.096-1.056 0.32-1.184 0.416-0.096 0.096-0.096 0.192-0.032 0.544 0.096 0.448 0.096 1.312 0 1.824-0.032 0.16-0.128 0.576-0.192 0.928-0.064 0.32-0.096 0.64-0.096 0.64 0 0.032 0 0.096 0 0.128-0.032 0.064-0.096 0.352-0.128 0.576-0.032 0.192-0.128 0.704-0.192 1.024-0.032 0.096-0.064 0.32-0.064 0.48-0.032 0.16-0.064 0.32-0.064 0.384-0.032 0.032-0.064 0.256-0.096 0.48-0.064 0.224-0.096 0.448-0.096 0.48 0 0-0.064 0.32-0.128 0.704-0.096 0.576-0.128 0.64-0.352 0.736-0.128 0.064-0.224 0.128-0.192 0.128 0.032 0.032-0.032 0.064-0.096 0.064-0.096 0-0.32 0.064-0.512 0.16-0.864 0.32-1.856 0.064-1.92-0.512 0-0.096-0.032-0.224-0.032-0.288 0-0.16 0.16-1.472 0.192-1.472 0 0 0.032-0.064 0.032-0.16s0.032-0.288 0.064-0.416c0.032-0.128 0.096-0.384 0.096-0.512 0.128-0.704 0.192-1.152 0.256-1.44 0.032-0.128 0.064-0.384 0.096-0.544 0.032-0.192 0.128-0.8 0.256-1.344 0.288-1.632 0.16-2.432-0.416-2.784-0.16-0.064-0.288-0.16-0.352-0.16-0.512-0.096-0.864-0.16-0.896-0.16z"></path></svg>',
        'sms' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M24 10.688v-2.688h-16v2.688h16zM18.688 18.688v-2.688h-10.688v2.688h10.688zM8 12v2.688h16v-2.688h-16zM26.688 2.688c1.438 0 2.625 1.188 2.625 2.625v16c0 1.438-1.188 2.688-2.625 2.688h-18.688l-5.313 5.313v-24c0-1.438 1.188-2.625 2.625-2.625h21.375z"></path></svg>',
        'plus' => '<svg height="32" viewBox="0 0 32 32" width="32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M32,13.8v4.4c0,0.6-0.2,1.1-0.6,1.6c-0.4,0.4-1,0.6-1.5,0.6h-9.5v9.4c0,0.6-0.2,1.2-0.6,1.6s-1,0.6-1.6,0.6h-4.3c-0.6,0-1.2-0.2-1.6-0.6c-0.4-0.4-0.6-1-0.6-1.6v-9.4H2.1c-0.6,0-1.1-0.2-1.5-0.6c-0.4-0.5-0.6-1-0.6-1.6v-4.4c0-0.6,0.2-1.1,0.6-1.5c0.4-0.4,1-0.6,1.5-0.6h9.5V2.1c0-0.6,0.2-1.1,0.6-1.5c0.4-0.5,1-0.6,1.6-0.6h4.3c0.6,0,1.2,0.2,1.6,0.6c0.4,0.4,0.6,0.9,0.6,1.5v9.5h9.5c0.6,0,1.1,0.2,1.5,0.6C31.8,12.7,32,13.2,32,13.8z"/></svg>',
        'minus' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M32,13.8v4.4c0,0.6-0.2,1.1-0.6,1.6c-0.4,0.4-1,0.6-1.5,0.6H2.1c-0.6,0-1.1-0.2-1.5-0.6c-0.4-0.5-0.6-1-0.6-1.6v-4.4c0-0.6,0.2-1.1,0.6-1.5c0.4-0.4,1-0.6,1.5-0.6h27.7c0.6,0,1.1,0.2,1.5,0.6C31.8,12.7,32,13.2,32,13.8z"/></svg>',
        'close' => '<svg height="32" viewBox="0 0 32 32" width="32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M32,25.7c0,0.7-0.3,1.3-0.8,1.8l-3.7,3.7c-0.5,0.5-1.1,0.8-1.9,0.8c-0.7,0-1.3-0.3-1.8-0.8L16,23.3l-7.9,7.9C7.6,31.7,7,32,6.3,32c-0.8,0-1.4-0.3-1.9-0.8l-3.7-3.7C0.3,27.1,0,26.4,0,25.7c0-0.8,0.3-1.3,0.8-1.9L8.7,16L0.8,8C0.3,7.6,0,6.9,0,6.3c0-0.8,0.3-1.3,0.8-1.9l3.7-3.6C4.9,0.2,5.6,0,6.3,0C7,0,7.6,0.2,8.1,0.8L16,8.7l7.9-7.9C24.4,0.2,25,0,25.7,0c0.8,0,1.4,0.2,1.9,0.8l3.7,3.6C31.7,4.9,32,5.5,32,6.3c0,0.7-0.3,1.3-0.8,1.8L23.3,16l7.9,7.9C31.7,24.4,32,25,32,25.7z"/></svg>',
        'share' => '<svg height="32" viewBox="0 0 36 32" width="36" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M35.9,11.6c0,0.4-0.1,0.6-0.4,0.9L25.3,22.7C25.1,23,24.7,23,24.4,23c-0.4,0-0.6-0.1-0.8-0.4c-0.3-0.3-0.4-0.6-0.4-0.9v-5.1h-4.5c-1.3,0-2.5,0.1-3.5,0.1c-1.1,0.1-2,0.2-3.1,0.4c-1.1,0.2-1.9,0.5-2.7,0.8c-0.8,0.4-1.5,0.8-2.1,1.4s-1.2,1.3-1.6,2s-0.8,1.7-1,2.7c-0.2,1.1-0.4,2.3-0.4,3.6c0,0.7,0.1,1.5,0.1,2.5c0,0.1,0,0.3,0,0.5c0.1,0.2,0.1,0.4,0.1,0.5c0,0.2-0.1,0.4-0.1,0.6C4.3,31.9,4.1,32,3.9,32s-0.4-0.1-0.6-0.3c-0.1-0.1-0.2-0.3-0.3-0.5c-0.1-0.1-0.1-0.4-0.3-0.6c-0.1-0.3-0.1-0.4-0.2-0.5c-1.7-3.8-2.5-6.8-2.5-9c0-2.7,0.4-4.9,1.1-6.7c2.2-5.4,8-8.1,17.5-8.1h4.5V1.3c0-0.4,0.1-0.7,0.4-0.9C23.7,0.1,24,0,24.4,0c0.4,0,0.7,0.1,0.9,0.4l10.3,10.2C35.8,10.9,35.9,11.2,35.9,11.6z"/></svg>',
        'share-alt-square' => '<svg height="32" viewBox="0 0 32 32" width="32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M26.7,22.2c0-1.2-0.4-2.3-1.3-3.1c-0.8-0.9-1.9-1.3-3.1-1.3c-1.2,0-2.1,0.4-3,1.2l-5-2.5c0.1-0.2,0.1-0.4,0.1-0.5s0-0.3-0.1-0.5l5-2.5c0.9,0.8,1.8,1.2,3,1.2c1.2,0,2.3-0.4,3.1-1.3c0.9-0.9,1.3-2,1.3-3.1c0-1.2-0.4-2.3-1.3-3.1c-0.8-0.9-1.9-1.3-3.1-1.3c-1.2,0-2.3,0.4-3.1,1.3c-0.9,0.8-1.3,1.9-1.3,3.1c0,0.1,0,0.2,0.1,0.4l-5,2.5c-0.9-0.7-1.9-1.2-3-1.2c-1.2,0-2.3,0.4-3.1,1.3c-0.9,0.9-1.3,1.9-1.3,3.1s0.4,2.3,1.3,3.1c0.8,0.9,1.9,1.3,3.1,1.3c1.1,0,2.1-0.4,3-1.2l5,2.5c-0.1,0.2-0.1,0.4-0.1,0.4c0,1.2,0.4,2.3,1.3,3.1c0.9,0.9,2,1.3,3.1,1.3c1.2,0,2.3-0.4,3.1-1.3C26.2,24.5,26.7,23.5,26.7,22.2z M32,6v20c0,1.7-0.6,3.1-1.8,4.2C29.1,31.4,27.7,32,26,32H6c-1.7,0-3.1-0.6-4.2-1.8C0.6,29.1,0,27.7,0,26V6c0-1.7,0.6-3.1,1.8-4.2S4.3,0,6,0h20c1.7,0,3.1,0.6,4.2,1.8C31.4,2.9,32,4.3,32,6z"/></svg>',
        'share-alt' => '<svg height="32" viewBox="0 0 32 32" width="32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M25.4,18.7c1.8,0,3.4,0.6,4.7,1.9c1.3,1.3,1.9,2.9,1.9,4.7c0,1.8-0.6,3.4-1.9,4.7c-1.3,1.3-2.9,1.9-4.7,1.9c-1.8,0-3.4-0.6-4.7-1.9c-1.3-1.3-1.9-2.9-1.9-4.7c0-0.1,0-0.4,0-0.7l-7.5-3.7c-1.2,1.2-2.8,1.8-4.5,1.8c-1.8,0-3.4-0.6-4.7-1.9C0.6,19.4,0,17.8,0,16s0.6-3.4,1.9-4.7s2.9-1.9,4.7-1.9c1.8,0,3.3,0.6,4.5,1.8l7.5-3.7c0-0.3,0-0.6,0-0.7c0-1.8,0.6-3.4,1.9-4.7C21.9,0.6,23.5,0,25.4,0c1.8,0,3.4,0.6,4.7,1.9C31.4,3.2,32,4.8,32,6.6s-0.6,3.4-1.9,4.7c-1.3,1.3-2.9,1.9-4.7,1.9c-1.8,0-3.3-0.6-4.5-1.8l-7.5,3.7c0,0.3,0,0.6,0,0.7c0,0.1,0,0.4,0,0.7l7.5,3.7C22.1,19.3,23.6,18.7,25.4,18.7z"/></svg>',
        'share-tiny' => '<svg height="32" viewBox="0 0 32 32" width="32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M24.9,21.4c1.5,0,2.7,0.5,3.8,1.5c1,1,1.6,2.3,1.6,3.8c0,1.5-0.6,2.7-1.6,3.8c-1,1-2.3,1.5-3.8,1.5c-1.5,0-2.7-0.5-3.8-1.5c-1-1-1.6-2.3-1.6-3.8c0-0.1,0-0.3,0.1-0.6c0-0.1,0-0.3,0-0.4l-9.3-5.6c-1,0.8-2.1,1.2-3.3,1.2c-1.5,0-2.7-0.6-3.8-1.6S1.7,17.5,1.7,16s0.6-2.7,1.6-3.8s2.3-1.6,3.8-1.6c1.3,0,2.4,0.3,3.3,1.1l9.3-5.6c0-0.1,0-0.3,0-0.4c-0.1-0.2-0.1-0.3-0.1-0.5c0-1.5,0.6-2.7,1.6-3.8c1-1,2.3-1.5,3.8-1.5c1.5,0,2.7,0.5,3.8,1.5c1,1,1.6,2.3,1.6,3.8c0,1.5-0.6,2.8-1.6,3.8s-2.3,1.5-3.8,1.5c-1.3,0-2.3-0.3-3.2-1.1l-9.3,5.6c0,0.1,0.1,0.5,0.1,0.9c0,0.3-0.1,0.7-0.1,0.8l9.3,5.6C22.5,21.7,23.7,21.4,24.9,21.4"/></svg>',
        'share-outline' => '<svg height="32" viewBox="0 0 32 32" width="32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M26.7,21.3c-1.6,0-3.1,0.8-4,1.9l-9.8-4.9c0.3-0.8,0.4-1.5,0.4-2.3s-0.1-1.6-0.4-2.3l9.8-4.9c0.9,1.1,2.4,1.9,4,1.9c2.9,0,5.3-2.4,5.3-5.4S29.6,0,26.7,0s-5.4,2.4-5.4,5.3c0,0.4,0.1,0.8,0.1,1.1l-9.9,5l0,0c-1.2-1.3-2.9-2.1-4.8-2.1C3,9.3,0,12.3,0,16s3,6.7,6.7,6.7c1.9,0,3.6-0.8,4.8-2.1l0,0l9.9,5c-0.1,0.4-0.1,0.8-0.1,1.1c0,2.9,2.4,5.3,5.4,5.3s5.3-2.4,5.3-5.3S29.6,21.3,26.7,21.3z M26.7,2.7c1.4,0,2.6,1.2,2.6,2.6c0,1.5-1.2,2.7-2.6,2.7C25.2,8,24,6.8,24,5.3C24,3.9,25.2,2.7,26.7,2.7z M6.7,20c-2.3,0-4-1.8-4-4s1.8-4,4-4c2.2,0,4,1.8,4,4S8.9,20,6.7,20z M26.7,29.3c-1.5,0-2.7-1.2-2.7-2.6c0-1.5,1.2-2.7,2.7-2.7c1.4,0,2.6,1.2,2.6,2.7C29.3,28.1,28.1,29.3,26.7,29.3z"/></svg>',
        'ellipsis-h' => '<svg height="32" viewBox="0 0 32 32" width="32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M8.8,13.8v4.4c0,0.6-0.2,1.1-0.6,1.6c-0.5,0.4-1,0.6-1.6,0.6H2.1c-0.6,0-1.1-0.2-1.5-0.6c-0.4-0.5-0.6-1-0.6-1.6v-4.4c0-0.6,0.2-1.1,0.6-1.5c0.4-0.4,1-0.6,1.5-0.6h4.4c0.6,0,1.1,0.2,1.6,0.6C8.5,12.7,8.8,13.2,8.8,13.8z M20.4,13.8v4.4c0,0.6-0.2,1.1-0.6,1.6c-0.4,0.4-1,0.6-1.6,0.6h-4.3c-0.6,0-1.2-0.2-1.6-0.6c-0.4-0.5-0.6-1-0.6-1.6v-4.4c0-0.6,0.2-1.1,0.6-1.5c0.4-0.4,1-0.6,1.6-0.6h4.3c0.6,0,1.2,0.2,1.6,0.6C20.1,12.7,20.4,13.2,20.4,13.8z M32,13.8v4.4c0,0.6-0.2,1.1-0.6,1.6c-0.4,0.4-1,0.6-1.5,0.6h-4.4c-0.6,0-1.1-0.2-1.6-0.6c-0.4-0.5-0.6-1-0.6-1.6v-4.4c0-0.6,0.2-1.1,0.6-1.5c0.5-0.4,1-0.6,1.6-0.6h4.4c0.6,0,1.1,0.2,1.5,0.6C31.8,12.7,32,13.2,32,13.8z"/></svg>',
        'viber' => '<svg height="32" viewBox="0 0 32 32" width="32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="m23.155 13.893c.716-6.027-.344-9.832-2.256-11.553l.001-.001c-3.086-2.939-13.508-3.374-17.2.132-1.658 1.715-2.242 4.232-2.306 7.348-.064 3.117-.14 8.956 5.301 10.54h.005l-.005 2.419s-.037.98.589 1.177c.716.232 1.04-.223 3.267-2.883 3.724.323 6.584-.417 6.909-.525.752-.252 5.007-.815 5.695-6.654zm-12.237 5.477s-2.357 2.939-3.09 3.702c-.24.248-.503.225-.499-.267 0-.323.018-4.016.018-4.016-4.613-1.322-4.341-6.294-4.291-8.895.05-2.602.526-4.733 1.93-6.168 3.239-3.037 12.376-2.358 14.704-.17 2.846 2.523 1.833 9.651 1.839 9.894-.585 4.874-4.033 5.183-4.667 5.394-.271.09-2.786.737-5.944.526z"/><path d="m12.222 4.297c-.385 0-.385.6 0 .605 2.987.023 5.447 2.105 5.474 5.924 0 .403.59.398.585-.005h-.001c-.032-4.115-2.718-6.501-6.058-6.524z"/><path d="m16.151 10.193c-.009.398.58.417.585.014.049-2.269-1.35-4.138-3.979-4.335-.385-.028-.425.577-.041.605 2.28.173 3.481 1.729 3.435 3.716z"/><path d="m15.521 12.774c-.494-.286-.997-.108-1.205.173l-.435.563c-.221.286-.634.248-.634.248-3.014-.797-3.82-3.951-3.82-3.951s-.037-.427.239-.656l.544-.45c.272-.216.444-.736.167-1.247-.74-1.337-1.237-1.798-1.49-2.152-.266-.333-.666-.408-1.082-.183h-.009c-.865.506-1.812 1.453-1.509 2.428.517 1.028 1.467 4.305 4.495 6.781 1.423 1.171 3.675 2.371 4.631 2.648l.009.014c.942.314 1.858-.67 2.347-1.561v-.007c.217-.431.145-.839-.172-1.106-.562-.548-1.41-1.153-2.076-1.542z"/><path d="m13.169 8.104c.961.056 1.427.558 1.477 1.589.018.403.603.375.585-.028-.064-1.346-.766-2.096-2.03-2.166-.385-.023-.421.582-.032.605z"/></svg>',
        'telegram' => '<svg width="28" height="32" viewBox="0 0 28 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M27.919 6.162l-4.225 19.925c-0.319 1.406-1.15 1.756-2.331 1.094l-6.438-4.744-3.106 2.988c-0.344 0.344-0.631 0.631-1.294 0.631l0.463-6.556 11.931-10.781c0.519-0.463-0.113-0.719-0.806-0.256l-14.75 9.287-6.35-1.988c-1.381-0.431-1.406-1.381 0.288-2.044l24.837-9.569c1.15-0.431 2.156 0.256 1.781 2.013z"></path></svg>',
        'prev' => '<svg height="32" viewBox="0 0 32 32" width="32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M25.9,5.5L15.4,16l10.6,10.5c0.2,0.3,0.3,0.6,0.3,0.9c0,0.3-0.1,0.7-0.3,0.9l-3.3,3.3C22.4,31.9,22,32,21.7,32c-0.3,0-0.6-0.1-0.8-0.3L6.1,16.9c-0.3-0.3-0.4-0.6-0.4-0.9c0-0.3,0.1-0.7,0.4-0.9L20.9,0.4C21.1,0.1,21.3,0,21.7,0c0.3,0,0.7,0.1,0.9,0.4l3.3,3.3c0.2,0.3,0.3,0.6,0.3,0.9C26.3,4.9,26.1,5.2,25.9,5.5z"/></svg>',
        'next' => '<svg height="32" viewBox="0 0 32 32" width="32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M25.9,16.9L11.1,31.7c-0.2,0.2-0.5,0.3-0.8,0.3s-0.7-0.1-0.9-0.3l-3.3-3.3c-0.2-0.2-0.3-0.6-0.3-0.9c0-0.3,0.1-0.6,0.3-0.9L16.6,16L6.1,5.5C5.9,5.2,5.7,4.9,5.7,4.6c0-0.3,0.1-0.6,0.3-0.9l3.3-3.3C9.6,0.1,10,0,10.3,0s0.6,0.1,0.8,0.4l14.7,14.7c0.3,0.2,0.4,0.6,0.4,0.9C26.3,16.4,26.1,16.7,25.9,16.9z"/></svg>',
        'clock' => '<svg height="32" viewBox="0 0 32 32" width="32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M18.7,8.6V18c0,0.2-0.1,0.4-0.2,0.5s-0.3,0.2-0.5,0.2h-6.6c-0.2,0-0.4-0.1-0.5-0.2c-0.1-0.1-0.1-0.3-0.1-0.5v-1.3c0-0.2,0.1-0.4,0.1-0.4c0.1-0.1,0.3-0.2,0.5-0.2H16V8.6c0-0.1,0.1-0.3,0.2-0.4C16.3,8,16.4,8,16.7,8H18c0.2,0,0.4,0.1,0.5,0.2C18.6,8.3,18.7,8.5,18.7,8.6z M27.3,16c0-2-0.5-3.9-1.5-5.7c-1-1.8-2.4-3.1-4.2-4.2C19.9,5.2,18,4.7,16,4.7s-3.9,0.5-5.7,1.5c-1.8,1-3.1,2.4-4.2,4.2C5.2,12.1,4.7,14,4.7,16s0.5,3.9,1.5,5.7c1,1.8,2.4,3.1,4.2,4.2c1.8,0.9,3.7,1.5,5.7,1.5s3.9-0.5,5.7-1.5c1.8-1,3.1-2.4,4.2-4.2C26.8,19.9,27.3,18,27.3,16z M32,16c0,2.9-0.7,5.6-2.1,8c-1.5,2.5-3.4,4.4-5.8,5.8c-2.4,1.5-5.1,2.1-8,2.1s-5.6-0.7-8-2.1c-2.5-1.5-4.4-3.4-5.8-5.8C0.7,21.6,0,18.9,0,16s0.7-5.6,2.1-8C3.6,5.5,5.5,3.6,8,2.1C10.4,0.7,13.1,0,16,0s5.6,0.7,8,2.1c2.5,1.5,4.4,3.4,5.8,5.8C31.3,10.4,32,13.1,32,16z"/></svg>',
        'youtube' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M31.688 9.625c0 0-0.313-2.25-1.25-3.188-1.25-1.313-2.625-1.313-3.25-1.375-4.438-0.313-11.188-0.313-11.188-0.313v0c0 0-6.75 0-11.188 0.313-0.625 0.063-2 0.063-3.25 1.375-0.938 0.938-1.25 3.188-1.25 3.188s-0.313 2.563-0.313 5.125v2.438c0 2.625 0.313 5.188 0.313 5.188s0.313 2.188 1.25 3.188c1.25 1.25 2.875 1.25 3.563 1.375 2.563 0.25 10.875 0.313 10.875 0.313s6.75 0 11.188-0.313c0.625-0.063 2-0.125 3.25-1.375 0.938-1 1.25-3.188 1.25-3.188s0.313-2.563 0.313-5.188v-2.438c0-2.563-0.313-5.125-0.313-5.125zM20.313 16.25v0l-7.563 3.938v-9l8.625 4.5z"></path></svg>',
        'skype' => '<svg height="32" viewBox="0 0 32 32" width="32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="m23.309 14.547c1.738-7.81-5.104-14.905-13.139-13.543-4.362-2.707-10.17.352-10.17 5.542 0 1.207.333 2.337.912 3.311-1.615 7.828 5.283 14.821 13.311 13.366 5.675 3.001 11.946-2.984 9.086-8.676zm-7.638 4.71c-2.108.867-5.577.872-7.676-.227-2.993-1.596-3.525-5.189-.943-5.189 1.946 0 1.33 2.269 3.295 3.194.902.417 2.841.46 3.968-.3 1.113-.745 1.011-1.917.406-2.477-1.603-1.48-6.19-.892-8.287-3.483-.911-1.124-1.083-3.107.037-4.545 1.952-2.512 7.68-2.665 10.143-.768 2.274 1.76 1.66 4.096-.175 4.096-2.207 0-1.047-2.888-4.61-2.888-2.583 0-3.599 1.837-1.78 2.731 2.466 1.225 8.75.816 8.75 5.603-.005 1.992-1.226 3.477-3.128 4.253z"/></svg>',
        'messenger' => '<svg height="32" viewBox="0 0 32 32" width="32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="m0 11.111c0 3.496 1.744 6.615 4.471 8.652v4.237l4.086-2.242c1.09.301 2.245.465 3.442.465 6.627 0 12-4.974 12-11.111.001-6.137-5.372-11.112-11.999-11.112s-12 4.974-12 11.111zm10.734-3.112 3.13 3.259 5.887-3.259-6.56 6.962-3.055-3.258-5.963 3.259z"/></svg>',
        'kakaotalk' => '<svg height="32" viewBox="0 0 32 32" width="32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M11.6,15.1h1.8l-0.9-2.7L11.6,15.1z M15.9,1.3C7.1,1.3,0,6.9,0,13.8c0,4.5,2.9,8.4,7.5,10.7c-0.3,0.9-1.6,5.4-1.6,5.7c0,0,0,0.3,0.1,0.4c0.2,0.1,0.4,0,0.4,0c0.4-0.1,5.8-3.9,6.7-4.5c1,0.1,1.9,0.1,2.9,0.1c8.7,0,15.9-5.6,15.9-12.6C31.8,6.9,24.7,1.3,15.9,1.3z M8,17.4c0,0.4-0.4,0.9-0.9,0.9c-0.5,0-0.9-0.4-0.9-0.9v-5.5H4.8c-0.5,0-0.9-0.4-0.9-0.9c0-0.4,0.4-0.9,0.9-0.9h4.7c0.5,0,0.9,0.4,0.9,0.9c0,0.5-0.4,0.9-0.9,0.9H8L8,17.4L8,17.4z M15.7,18.1c-0.1,0.1-0.4,0.2-0.6,0.2c-0.4,0-0.6-0.2-0.7-0.4l-0.5-1.2h-2.8l-0.4,1.2c-0.1,0.3-0.4,0.4-0.8,0.4c-0.3,0-0.4-0.1-0.6-0.2c-0.3-0.1-0.5-0.4-0.3-1.2l2.2-5.8c0.1-0.4,0.6-0.9,1.2-0.9c0.6,0,1.1,0.5,1.2,0.9l2.2,5.8C16.2,17.7,16,18,15.7,18.1z M20.4,18.1h-3c-0.4,0-0.9-0.4-0.9-0.9V11c0-0.4,0.4-0.9,1-0.9c0.4,0,0.9,0.4,0.9,0.9v5.4h2c0.5,0,0.9,0.4,0.9,0.9C21.3,17.7,20.8,18.1,20.4,18.1z M27.6,17.4c0,0.3-0.1,0.5-0.3,0.6c-0.2,0.2-0.3,0.2-0.6,0.2c-0.3,0-0.6-0.2-0.7-0.4l-2.2-2.9l-0.3,0.3v2c0,0.5-0.4,1-0.9,1s-1-0.4-1-1V11c0-0.4,0.4-0.9,1-0.9c0.4,0,0.9,0.4,0.9,0.9v2l2.5-2.6c0.1-0.1,0.3-0.2,0.5-0.2s0.4,0.1,0.6,0.2c0.1,0.2,0.3,0.4,0.3,0.6c0,0.3-0.1,0.4-0.3,0.6l-2.1,2.1l2.2,3C27.5,16.9,27.6,17.2,27.6,17.4z"/></svg>',
        'livejournal' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M11 3.125c0 0 0 0 0 0s0 0 0 0 0 0 0 0zM16.938 1.875c-2.125 0-4.125 0.438-5.938 1.25 0.125 0.063 0.188 0.125 0.313 0.25 0.313 0.313 0.625 0.625 0.938 0.938 0.063 0.063 0.063 0.063 0.063 0.063l10.75 10.75c-3.313 1.938-5.875 4.563-7.75 8l-10.813-10.813c-0.063-0.063-0.063-0.063-0.125-0.125-0.313-0.375-0.688-0.688-1-1-0.063-0.063-0.125-0.125-0.188-0.25 1.625-3.563 4.188-6.188 7.875-7.75-0.063-0.063-0.063-0.063-0.063-0.063s0 0 0 0c-0.938-0.938-1.875-1.813-2.75-2.75-0.375-0.313-0.688-0.438-1.125-0.188-0.563 0.25-1.063 0.563-1.563 0.875-1.75 1.188-3.188 2.625-4.375 4.313-0.375 0.563-0.75 1.125-1.063 1.813-0.188 0.375-0.188 0.625 0.188 0.938 0.938 0.938 1.875 1.875 2.813 2.813-0.813 1.813-1.188 3.875-1.188 5.938 0 8.313 6.75 15.063 15 15.063 8.313 0 15.063-6.75 15.063-15.063 0-8.25-6.75-15-15.063-15zM18.5 24.313c1.25-2.875 3.25-4.813 6-6.125 0.5 2.563 1 5 1.5 7.688-2.625-0.563-5-1.063-7.5-1.563z"/></svg>',
        'meetedgar' => '<svg height="32" viewBox="0 0 32 32" width="32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M14.9,4.4c5.2,0,9.4,4.1,9.4,9.1c0,3.1-1.5,5.7-3.8,7.4c0.7,0.4,1.6,0.6,2.6,0.6c2.3,0,4.3-1.5,5.1-3.5c0.1,0.6,0.2,1.1,0.2,1.7c0,3.1-2.6,5.7-5.9,5.7c-1.7,0-3.1-0.6-4.3-1.8c0.3,0.6,0.6,1,1.1,1.4c1,0.9,2.3,1.3,3.6,1.3c0.9,0,1.9-0.2,2.7-0.6c-0.3,0.5-0.6,1-1,1.4c-1.1,1.2-2.7,1.9-4.3,1.9c-1.4,0-2.8-0.5-3.9-1.6c-0.7-0.6-1.3-1.4-1.6-2.3c-0.3,0.9-0.9,1.6-1.6,2.3c-1.1,0.9-2.6,1.5-3.9,1.5c-1.6,0-3.2-0.6-4.3-1.8c-0.4-0.5-0.7-0.9-0.9-1.4c0.6,0.5,1.5,0.7,2.4,0.7c1.3,0,2.6-0.4,3.6-1.3c0.3-0.3,0.6-0.7,0.9-1c-1.1,0.8-2.3,1.3-3.7,1.3c-3.3,0-5.9-2.6-5.9-5.7c0-0.6,0.1-1.2,0.3-1.7c0.8,2.1,2.8,3.5,5.1,3.5c0.9,0,1.8-0.3,2.5-0.6c-2.3-1.7-3.8-4.3-3.8-7.3C5.4,8.5,9.6,4.4,14.9,4.4 M14.9,3.1C8.9,3.1,4.1,7.8,4.1,13.5c0,2.4,0.9,4.8,2.4,6.6c-1.6-0.1-3.1-1.1-3.6-2.6c-0.1-0.6-0.7-0.9-1.3-0.9s-1.1,0.4-1.3,0.9C0.1,18.3,0,18.9,0,19.7c0,2.3,1.1,4.1,2.6,5.4c-0.1,0.4-0.3,0.8,0,1.2c0.3,0.6,0.8,1.3,1.2,1.8c1.4,1.4,3.4,2.3,5.4,2.3c1.8,0,3.6-0.6,4.8-1.8c0.3-0.3,0.5-0.4,0.6-0.6c0.3,0.3,0.5,0.4,0.8,0.7c1.4,1.2,3,1.9,4.8,1.9c2,0,4-0.8,5.3-2.3c0.5-0.6,0.9-1.1,1.3-1.8c0.1-0.3,0.1-0.7,0-1c1.8-1.3,2.9-3.4,2.9-5.6c0-0.7-0.1-1.4-0.4-2.1c-0.1-0.6-0.7-0.9-1.3-1c-0.6,0-1.1,0.4-1.3,0.9c-0.5,1.6-1.9,2.6-3.6,2.7c1.5-1.9,2.4-4.2,2.4-6.7C25.7,7.8,20.8,3.1,14.9,3.1z M19.1,11.5c-1.7,0-3.1,1.4-3.3,3.1h-2.1c-0.1-1.7-1.5-3.1-3.3-3.1c-1.9,0-3.3,1.4-3.3,3.3c0,1.8,1.4,3.3,3.3,3.3c1.7,0,3-1.3,3.3-2.9h2.1c0.2,1.7,1.6,2.9,3.3,2.9c1.8,0,3.3-1.4,3.3-3.3C22.4,12.9,20.9,11.5,19.1,11.5z M10.6,17.6c-1.5,0-2.8-1.3-2.8-2.8c0-1.6,1.3-2.8,2.8-2.8s2.8,1.3,2.8,2.8C13.4,16.3,12.1,17.6,10.6,17.6z M19.1,17.6c-1.5,0-2.8-1.3-2.8-2.8c0-1.6,1.3-2.8,2.8-2.8s2.8,1.3,2.8,2.8C21.9,16.3,20.6,17.6,19.1,17.6z M19.1,18.3c-1.7,0-3.1-1.3-3.4-2.9h-1.8c-0.3,1.7-1.7,2.9-3.4,2.9c-1.8,0-3.4-1.5-3.4-3.4c0-1.8,1.6-3.4,3.4-3.4c1.8,0,3.2,1.3,3.4,3.1h1.8c0.2-1.7,1.7-3.1,3.4-3.1c1.8,0,3.4,1.6,3.4,3.4C22.5,16.8,21.1,18.3,19.1,18.3z M13.7,15.1H16v0.1c0.2,1.6,1.5,2.8,3.1,2.8c1.8,0,3.1-1.4,3.1-3.1s-1.4-3.1-3.1-3.1c-1.6,0-3.1,1.3-3.1,2.9v0.1h-2.3v-0.1c-0.2-1.6-1.5-2.9-3.1-2.9c-1.8,0-3.1,1.4-3.1,3.1s1.4,3.1,3.1,3.1C12.2,17.9,13.5,16.8,13.7,15.1L13.7,15.1z M19.1,17.8c-1.6,0-2.9-1.3-2.9-2.9s1.3-2.9,2.9-2.9s2.9,1.3,2.9,2.9S20.8,17.8,19.1,17.8z M19.1,12.2c-1.4,0-2.6,1.2-2.6,2.6s1.2,2.6,2.6,2.6s2.6-1.2,2.6-2.6S20.6,12.2,19.1,12.2z M10.6,17.8c-1.6,0-2.9-1.3-2.9-2.9S8.9,12,10.6,12s2.9,1.3,2.9,2.9S12.2,17.8,10.6,17.8z M10.6,12.2c-1.4,0-2.6,1.2-2.6,2.6s1.2,2.6,2.6,2.6s2.6-1.2,2.6-2.6S12,12.2,10.6,12.2z M28.4,5.9c0,0.4-0.3,0.7-0.7,0.7s-0.8-0.3-0.8-0.7c0-0.4,0.4-0.8,0.8-0.8S28.4,5.5,28.4,5.9z M30.3,1.5c-1,0-1.8,0.8-1.8,1.8c0,1,0.8,1.8,1.8,1.8c0.9,0,1.8-0.8,1.8-1.8C32,2.3,31.2,1.5,30.3,1.5z M30.3,4.3c-0.5,0-0.9-0.4-0.9-0.9c0-0.5,0.4-0.9,0.9-0.9s0.9,0.4,0.9,0.9C31.1,3.8,30.8,4.3,30.3,4.3z"/></svg>',
        'fintel' => '<svg height="32" viewBox="0 0 32 32" width="32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M15.9,0c8.8,0,15.9,7.1,15.9,16c0,8.8-7.1,16-15.9,16c-1.9,0-3.8-0.4-5.5-1.1v0.1V19.3h6.8v-5.4h-6.8v-3.8H20V4.8H4.7v9.1H0.1C1.1,6,7.8,0,15.9,0z M8.7,30.2L8.7,30.2L8.7,30.2z M8.4,30.1c-0.1,0-0.1-0.1-0.2-0.1L8.4,30.1z M7.4,29.5c-0.1,0-0.1,0-0.1-0.1C7.3,29.5,7.3,29.5,7.4,29.5z M5.5,28.1L5.5,28.1L5.5,28.1z M5.3,27.8l-0.1-0.1L5.3,27.8z M5,27.6c-0.1,0-0.1-0.1-0.2-0.1C4.9,27.5,4.9,27.6,5,27.6z M4.7,27.3c-2.2-2.2-3.8-4.9-4.5-8.1h4.5V27.3z M9.5,30.6l0.4,0.2V18.8h6.8v-4.5H10V9.8h9.4V5.5h-0.3v3.8H9.4v5.3h6.9v3.7H9.5V30.6z"/></svg>',
        'mix' => '<svg width="28" height="32" viewBox="0 0 28 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M0 4v21.806c0 3.512 5.5 3.631 5.5 0v-14.912c0.494-3.306 5.5-3.15 5.5 0.406v10.956c0 3.619 6 3.625 6 0v-7.256c0.331-3.419 5.5-3.281 5.5 0.269v1.487c0 3.744 5.5 3.538 5.5 0v-12.756h-28z"/></svg>',
        'instapaper' => '<svg height="32" viewBox="0 0 32 32" width="32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M23.1,31.1c-1.9-0.1-3.3-0.4-3.8-0.9s-0.9-1.6-0.9-3.5V5.3c0-1.8,0.3-2.9,0.9-3.4s1.9-0.8,3.8-0.9V0H8.9v0.9c2,0.1,3.3,0.4,3.8,0.9s0.9,1.6,0.9,3.4v21.5c0,1.9-0.3,3.1-0.9,3.5s-1.8,0.8-3.8,0.9V32h14.3V31.1z"/></svg>',
        'copy' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M25.313 28v-18.688h-14.625v18.688h14.625zM25.313 6.688c1.438 0 2.688 1.188 2.688 2.625v18.688c0 1.438-1.25 2.688-2.688 2.688h-14.625c-1.438 0-2.688-1.25-2.688-2.688v-18.688c0-1.438 1.25-2.625 2.688-2.625h14.625zM21.313 1.313v2.688h-16v18.688h-2.625v-18.688c0-1.438 1.188-2.688 2.625-2.688h16z"/></svg>',
        'link' => '<svg height="32" viewBox="0 0 32 32" width="32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M11.8,25.4c0.4-0.4,0.8-0.5,1.3-0.5s1,0.2,1.5,0.5c0.8,0.9,0.8,1.8,0,2.8l-1.7,1.6C11.4,31.2,9.6,32,7.6,32s-3.8-0.8-5.3-2.3S0,26.5,0,24.5c0-2.1,0.8-3.9,2.3-5.4l5.9-5.9c1.9-1.8,3.7-2.8,5.7-3c2-0.2,3.7,0.3,5.2,1.7c0.4,0.4,0.6,0.9,0.6,1.4c0,0.5-0.2,1-0.6,1.5c-0.9,0.9-1.9,0.9-2.8,0c-1.3-1.3-3.1-0.9-5.3,1.3l-5.9,5.9C4.4,22.6,4,23.5,4,24.5s0.4,1.8,1.1,2.4C5.8,27.6,6.6,28,7.6,28s1.8-0.4,2.5-1.1L11.8,25.4 M29.7,2.4C31.2,3.9,32,5.7,32,7.7s-0.8,3.8-2.3,5.3l-6.3,6.3c-2,2-4,2.9-6,2.9c-1.6,0-3.1-0.7-4.4-2c-0.4-0.4-0.5-0.8-0.5-1.3c0-0.5,0.2-1,0.5-1.5c0.4-0.3,0.9-0.5,1.4-0.5c0.5,0,1,0.2,1.4,0.5c1.3,1.3,3,1,4.8-0.9l6.3-6.2c0.8-0.7,1.2-1.6,1.2-2.5c0-1-0.4-1.9-1.2-2.5c-0.6-0.7-1.3-1.1-2.2-1.2S23,4.1,22.3,4.8l-2,2c-0.4,0.4-0.9,0.5-1.4,0.5s-1-0.2-1.4-0.5c-0.9-0.9-0.9-1.8,0-2.8l2-2c1.4-1.5,3.1-2.1,5.1-2S28.3,0.9,29.7,2.4"/></svg>',
        'itunes' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32" width="32" height="32"><path class="st0" d="M16,3.5C9.2,3.5,3.8,8.9,3.8,15.7S9.2,27.9,16,27.9s12.2-5.5,12.2-12.2C28.2,8.9,22.7,3.4,16,3.5L16,3.5z M21.6,20.6c-0.2,1-1,1.5-1.9,1.7c-0.9,0.2-1.6,0.2-2.3-0.4c-0.8-0.7-0.9-1.9-0.1-2.6c0.6-0.6,1.4-0.7,2.7-0.9c0.2,0,0.4-0.1,0.5-0.3c0.2-0.3,0.2-0.1,0.2-5.8c0-0.4-0.2-0.5-0.6-0.4c-0.3,0.1-6.6,1.2-6.6,1.2c-0.4,0.1-0.5,0.2-0.5,0.6c0,8.3,0,7.9-0.1,8.5c-0.2,0.6-0.5,1.1-1.1,1.4c-0.6,0.3-1.7,0.5-2.2,0.4c-1.5-0.3-2.1-2.1-1-3.1c0.6-0.6,1.4-0.7,2.7-0.9c0.2,0,0.4-0.1,0.6-0.3c0.4-0.4,0.1-9.1,0.2-9.6c0-0.2,0.1-0.3,0.3-0.5c0.2-0.1,0.4-0.2,0.5-0.2C20.1,8.2,20.9,8,21.1,8c0.4,0,0.6,0.2,0.6,0.6C21.7,20.8,21.7,20.2,21.6,20.6L21.6,20.6z M24.7,0H7.3C3.3,0,0,3.3,0,7.3v17.3C0,28.7,3.3,32,7.3,32h17.3c4.1,0,7.3-3.3,7.3-7.3V7.3C32,3.3,28.7,0,24.7,0z M16,29.4c-7.6,0-13.8-6.2-13.8-13.8S8.4,1.9,16,1.9s13.8,6.2,13.8,13.8S23.6,29.4,16,29.4z"/></svg>',
        'deviantart' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M30.188 17.125c-1.5-1.813-3.375-2.938-5.5-3.813-2.75-1.125-5.625-1.563-8.563-1.625-0.188 0-0.438 0-0.75 0 0-1 0-1.938 0-3-1.313 0.125-2.563 0.313-4.188 0.438 0 0.188 0 0.25 0 0.375 0 0.75 0 1.563 0 2.313 0.063 0.25-0.063 0.375-0.313 0.438-2.125 0.438-4.125 1.125-6 2.25-1.438 0.875-2.688 1.938-3.625 3.375-1.125 1.688-1.563 3.563-1.063 5.5 5.125 0 10.063 0 15.188 0 0-3.188 0-6.125 0-9.188 0.625 0 1.313 0 1.938 0 1.625 0.125 3.25 0.375 4.75 1 2 0.938 3.375 2.375 3.938 4.5 0.063 0.125 0.063 0.5 0.125 0.5-1.813 0-3.375 0-5.313 0 0 0 0-0.313 0-0.438 0-1.188 0-2.438 0-3.688 0-0.25-0.063-0.375-0.313-0.375-0.813-0.188-1.5-0.313-2.313-0.438-0.5-0.063-1.25-0.063-1.563-0.125 0 2.813 0 5.688 0 8.25 5.125 0 10.063 0 15.188 0 0.063-0.625 0.188-0.938 0.188-1.375 0.063-1.875-0.625-3.438-1.813-4.875zM11.188 20.188c-1.938 0-3.5 0-5.25 0 0.125-2.25 2.688-5.063 5.25-5.375 0 1.75 0 3.438 0 5.375z"></path></svg>',
        'paypal' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 27 32" width="27" height="32"><path class="st0" d="M7.8,18.8c-0.2,1.4-1.2,7.6-1.5,9.4c0,0.1-0.1,0.2-0.2,0.2H0.9c-0.5,0-0.9-0.5-0.9-1L4.1,1.3c0.1-0.7,0.7-1.2,1.4-1.2c10.7,0,11.6-0.3,14.3,0.8c4.2,1.6,4.6,5.6,3.1,9.9c-1.5,4.4-5.1,6.3-9.9,6.4C10.1,17.1,8.2,16.6,7.8,18.8L7.8,18.8z M25.1,8.7c-0.1-0.1-0.2-0.1-0.2,0.1c-0.1,0.8-0.4,1.6-0.6,2.4c-2.8,8-10.6,7.3-14.4,7.3c-0.4,0-0.7,0.2-0.8,0.7C7.5,29,7.2,31,7.2,31c-0.1,0.5,0.2,0.9,0.7,0.9h4.5c0.6,0,1.1-0.4,1.2-1c0-0.4-0.1,0.4,1-6.4c0.3-1.5,1-1.4,2.1-1.4c5,0,8.9-2,10-7.9C27.2,12.7,27.1,10.2,25.1,8.7L25.1,8.7z"/></svg>',
        'tripadvisor' => '<svg version="1.1" width="50" height="32" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 50 32" ><path d="M45.8,9.3l4.1-4.4h-9c-9.6-6.5-22.2-6.5-31.8,0H0.1l4.1,4.4C-0.9,14-1.2,21.9,3.4,26.9C8.1,32,16,32.3,21,27.7l4,4.3l4-4.3c5,4.7,12.9,4.4,17.6-0.7c2.1-2.3,3.3-5.3,3.3-8.5h0C49.9,15,48.4,11.7,45.8,9.3z M12.5,27c-4.7,0-8.4-3.8-8.4-8.4s3.8-8.4,8.4-8.4s8.4,3.8,8.4,8.4S17.2,27,12.5,27L12.5,27z M25,18.3c0-5.5-4-10.3-9.4-12.3c6-2.5,12.7-2.5,18.7,0C29,8,25,12.7,25,18.3z M37.4,27L37.4,27c-4.7,0-8.4-3.8-8.4-8.4s3.8-8.4,8.4-8.4c4.7,0,8.4,3.8,8.4,8.4C45.9,23.2,42.1,27,37.4,27z M12.5,14.1L12.5,14.1c-2.4,0-4.4,2-4.4,4.4c0,2.4,2,4.4,4.4,4.4s4.4-2,4.4-4.4l0,0v0C17,16.1,15,14.1,12.5,14.1C12.5,14.1,12.5,14.1,12.5,14.1z M37.4,14.1c-2.4,0-4.4,2-4.4,4.4c0,2.4,2,4.4,4.4,4.4c2.4,0,4.4-2,4.4-4.4l0,0C41.9,16.1,39.9,14.1,37.4,14.1z"/></svg>',
        'snapchat' => '<svg width="30" height="32" viewBox="0 0 30 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M15.143 2.571c3.214-0.036 5.875 1.768 7.214 4.661 0.411 0.875 0.482 2.232 0.482 3.196 0 1.143-0.089 2.268-0.161 3.411 0.143 0.071 0.339 0.125 0.5 0.125 0.643 0 1.179-0.482 1.821-0.482 0.607 0 1.482 0.429 1.482 1.143 0 1.714-3.589 1.393-3.589 2.893 0 0.268 0.107 0.518 0.214 0.768 0.857 1.875 2.482 3.679 4.411 4.482 0.464 0.196 0.929 0.304 1.429 0.411 0.321 0.071 0.5 0.304 0.5 0.625 0 1.214-3.089 1.714-3.911 1.839-0.357 0.554-0.089 1.857-1.036 1.857-0.732 0-1.464-0.232-2.25-0.232-0.375 0-0.75 0.018-1.107 0.089-2.125 0.357-2.839 2.643-6.321 2.643-3.357 0-4.161-2.286-6.232-2.643-0.375-0.071-0.75-0.089-1.125-0.089-0.804 0-1.571 0.268-2.214 0.268-1 0-0.696-1.321-1.071-1.893-0.821-0.125-3.911-0.625-3.911-1.839 0-0.321 0.179-0.554 0.5-0.625 0.5-0.107 0.964-0.214 1.429-0.411 1.911-0.786 3.571-2.607 4.411-4.482 0.107-0.25 0.214-0.5 0.214-0.768 0-1.5-3.607-1.214-3.607-2.875 0-0.696 0.821-1.143 1.446-1.143 0.554 0 1.107 0.464 1.804 0.464 0.196 0 0.393-0.036 0.571-0.125-0.071-1.125-0.161-2.25-0.161-3.393 0-0.964 0.071-2.339 0.482-3.214 1.571-3.393 4.232-4.625 7.786-4.661z"></path></svg>',
        'medium' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M31.75 7.313l-10.125-5.063c-0.063 0-0.063 0-0.125 0-0.125 0-0.313 0.063-0.375 0.125l-6.188 10.188 6.938 11.313 10-16.188c0.063-0.125 0-0.313-0.125-0.375zM11.625 9v10.938l9.75 4.875zM22.188 25.188l8.938 4.5c0.438 0.25 0.875 0 0.875-0.563v-19.875zM10.5 7.375l-9.313-4.625-0.625-0.375c-0.063 0-0.125-0.063-0.188-0.063-0.125 0-0.188 0.063-0.25 0.125s-0.125 0.188-0.125 0.375v21.313c0 0.375 0.25 0.813 0.563 0.938l9.188 4.625c0.125 0.063 0.25 0.125 0.375 0.125 0.313 0 0.5-0.25 0.5-0.688v-21.563c0-0.063 0-0.125-0.125-0.188z"></path></svg>',
        'tiktok' => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32" width="32" height="32><path d="M16.707 0.027c1.747-0.027 3.48-0.013 5.213-0.027 0.107 2.040 0.84 4.12 2.333 5.56 1.493 1.48 3.6 2.16 5.653 2.387v5.373c-1.92-0.067-3.853-0.467-5.6-1.293-0.76-0.347-1.467-0.787-2.16-1.24-0.013 3.893 0.013 7.787-0.027 11.667-0.107 1.867-0.72 3.72-1.8 5.253-1.747 2.56-4.773 4.227-7.88 4.28-1.907 0.107-3.813-0.413-5.44-1.373-2.693-1.587-4.587-4.493-4.867-7.613-0.027-0.667-0.040-1.333-0.013-1.987 0.24-2.533 1.493-4.96 3.44-6.613 2.213-1.92 5.307-2.84 8.2-2.293 0.027 1.973-0.053 3.947-0.053 5.92-1.32-0.427-2.867-0.307-4.027 0.493-0.84 0.547-1.48 1.387-1.813 2.333-0.28 0.68-0.2 1.427-0.187 2.147 0.32 2.187 2.427 4.027 4.667 3.827 1.493-0.013 2.92-0.88 3.693-2.147 0.253-0.44 0.533-0.893 0.547-1.413 0.133-2.387 0.080-4.76 0.093-7.147 0.013-5.373-0.013-10.733 0.027-16.093z"></path></svg>',
        'patreon' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M32 12.175c0 6.331-5.15 11.488-11.488 11.488-6.356 0-11.525-5.15-11.525-11.488 0-6.35 5.169-11.519 11.525-11.519 6.338 0 11.488 5.169 11.488 11.519zM0 31.344h5.625v-30.688h-5.625v30.688z"></path></svg>',
        'mixer' => '<svg version="1.1" width="36" height="32" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 36 32"><path d="M6.6,1.5c-1.2-1.6-3.5-2-5.1-0.8C1.4,0.9,1.3,0.9,1.2,1c-1.4,1.3-1.5,3.5-0.4,5L8.2,16l-7.4,10c-1.1,1.5-1.1,3.7,0.4,5c1.5,1.4,3.8,1.3,5.2-0.2c0.1-0.1,0.2-0.2,0.2-0.3l10.4-13.9c0.2-0.3,0.2-0.8,0-1.1L6.6,1.5z M35.2,25.9l-7.4-10l7.4-9.9c1.1-1.5,1-3.7-0.4-5c-1.5-1.4-3.8-1.3-5.2,0.2c-0.1,0.1-0.2,0.2-0.2,0.3L19.1,15.4c-0.2,0.3-0.2,0.8,0,1.1l10.3,13.9c1.2,1.6,3.5,2,5.1,0.8c0.1-0.1,0.2-0.2,0.3-0.2C36.3,29.7,36.4,27.5,35.2,25.9z"/></svg>',
        'vimeo' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M20.688 9.125c-0.75 0-1.563 0.188-2.375 0.563 1.563-5.188 4.563-7.688 9-7.5 3.313 0.063 4.875 2.188 4.688 6.375-0.188 3.125-2.313 7.375-6.563 12.813-4.313 5.625-8 8.5-11 8.5-1.875 0-3.438-1.75-4.75-5.188-0.875-3.188-1.75-6.313-2.563-9.5-1-3.438-2-5.125-3.125-5.125-0.25 0-1.063 0.5-2.5 1.5l-1.5-1.938c1.563-1.438 3.125-2.813 4.688-4.188 2.063-1.813 3.688-2.75 4.75-2.875 2.438-0.25 4 1.438 4.563 5.125 0.625 3.938 1.063 6.375 1.313 7.313 0.688 3.25 1.5 4.875 2.375 4.875 0.688 0 1.688-1.063 3-3.125 1.313-2.125 2.063-3.75 2.188-4.875 0.188-1.813-0.563-2.75-2.188-2.75z"></path></svg>',
        'github' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M30.25 11.125c0-2.25-0.75-4.125-2.125-5.563 0.25-0.5 0.938-2.625-0.188-5.5 0 0-1.75-0.563-5.688 2.125-1.688-0.438-3.438-0.688-5.25-0.688-1.75 0-3.5 0.25-5.188 0.688-4-2.688-5.688-2.125-5.688-2.125-1.188 2.875-0.438 5-0.25 5.5-1.313 1.438-2.125 3.313-2.125 5.563 0 8 4.875 9.75 9.5 10.313-0.625 0.5-1.188 1.438-1.375 2.75-1.188 0.563-4.188 1.438-6-1.75 0 0-1.125-1.938-3.188-2.125 0 0-2.063 0-0.188 1.25 0 0 1.375 0.688 2.313 3.063 0 0 1.25 3.688 7 2.438 0.063 1.75 0.063 4.438 0.063 4.938h10.313c0-0.688 0-4 0-6.75 0-1.938-0.625-3.188-1.375-3.875 4.625-0.5 9.438-2.25 9.438-10.25zM4.125 21.313c-0.063 0.063-0.25 0.125-0.375 0.063s-0.25-0.25-0.188-0.313c0.063-0.125 0.188-0.188 0.375-0.063 0.125 0.063 0.188 0.188 0.188 0.313zM4.938 22.25c-0.063 0.063-0.313 0-0.438-0.125s-0.125-0.313-0.063-0.438c0.125-0.063 0.313-0.063 0.438 0.125 0.125 0.125 0.188 0.313 0.063 0.438zM5.75 23.438c-0.125 0.063-0.313 0-0.438-0.188s-0.125-0.438 0-0.5c0.125-0.063 0.313 0 0.438 0.188s0.125 0.375 0 0.5zM6.875 24.563c-0.125 0.125-0.375 0.125-0.5-0.063-0.188-0.188-0.25-0.375-0.125-0.5 0.125-0.188 0.375-0.125 0.5 0.063 0.188 0.125 0.25 0.375 0.125 0.5zM8.438 25.25c-0.063 0.188-0.313 0.25-0.5 0.188-0.25-0.063-0.438-0.25-0.375-0.438s0.313-0.25 0.563-0.188c0.188 0.063 0.375 0.25 0.313 0.438zM9.688 25.688c-0.25 0-0.438-0.125-0.438-0.313s0.188-0.313 0.438-0.313c0.25 0 0.438 0.125 0.438 0.313s-0.188 0.313-0.438 0.313zM11.313 25.5c-0.25 0.063-0.438-0.063-0.5-0.25 0-0.125 0.188-0.313 0.438-0.375s0.438 0.063 0.5 0.25c0 0.125-0.188 0.313-0.438 0.375z"></path></svg>',
        'instagram' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M16 2.875c4.313 0 4.75 0.063 6.438 0.125 1.625 0.063 2.438 0.313 3 0.5 0.75 0.313 1.313 0.688 1.813 1.188 0.563 0.563 0.938 1.125 1.188 1.813 0.25 0.625 0.5 1.438 0.563 3 0.063 1.75 0.125 2.188 0.125 6.5s-0.063 4.75-0.125 6.438c-0.063 1.625-0.313 2.438-0.5 3-0.313 0.75-0.688 1.313-1.188 1.813-0.563 0.563-1.125 0.938-1.813 1.188-0.625 0.25-1.438 0.5-3 0.563-1.75 0.063-2.188 0.125-6.5 0.125s-4.75-0.063-6.438-0.125c-1.625-0.063-2.438-0.313-3-0.5-0.75-0.313-1.313-0.688-1.813-1.188-0.563-0.563-0.938-1.125-1.188-1.813-0.25-0.625-0.5-1.438-0.563-3-0.063-1.75-0.125-2.188-0.125-6.5s0.063-4.75 0.125-6.438c0.063-1.625 0.313-2.438 0.5-3 0.313-0.75 0.688-1.313 1.188-1.813 0.563-0.563 1.125-0.938 1.813-1.188 0.625-0.25 1.438-0.5 3-0.563 1.75-0.063 2.188-0.125 6.5-0.125M16 0c-4.375 0-4.875 0.063-6.563 0.125-1.75 0.063-2.938 0.313-3.875 0.688-1.063 0.438-2 1-2.875 1.875s-1.438 1.813-1.875 2.875c-0.375 1-0.625 2.125-0.688 3.875-0.063 1.688-0.125 2.188-0.125 6.563s0.063 4.875 0.125 6.563c0.063 1.75 0.313 2.938 0.688 3.875 0.438 1.063 1 2 1.875 2.875s1.813 1.438 2.875 1.875c1 0.375 2.125 0.625 3.875 0.688 1.688 0.063 2.188 0.125 6.563 0.125s4.875-0.063 6.563-0.125c1.75-0.063 2.938-0.313 3.875-0.688 1.063-0.438 2-1 2.875-1.875s1.438-1.813 1.875-2.875c0.375-1 0.625-2.125 0.688-3.875 0.063-1.688 0.125-2.188 0.125-6.563s-0.063-4.875-0.125-6.563c-0.063-1.75-0.313-2.938-0.688-3.875-0.438-1.063-1-2-1.875-2.875s-1.813-1.438-2.875-1.875c-1-0.375-2.125-0.625-3.875-0.688-1.688-0.063-2.188-0.125-6.563-0.125zM16 7.75c-4.563 0-8.25 3.688-8.25 8.25s3.688 8.25 8.25 8.25c4.563 0 8.25-3.688 8.25-8.25s-3.688-8.25-8.25-8.25zM16 21.375c-2.938 0-5.375-2.438-5.375-5.375s2.438-5.375 5.375-5.375c2.938 0 5.375 2.438 5.375 5.375s-2.438 5.375-5.375 5.375zM26.438 7.438c0 1.063-0.813 1.938-1.875 1.938s-1.938-0.875-1.938-1.938c0-1.063 0.875-1.875 1.938-1.875s1.875 0.813 1.875 1.875z"></path></svg>',
        'soundcloud' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M0.625 21.125h-0.625v-3.875h0.625zM2.25 22.375h-0.625v-6.063h0.625zM3.5 22.75h-0.625v-7.063h0.625zM4.813 23.063h-0.625v-7.063h0.625zM6.375 23.063h-0.625v-9.313h0.625zM7.688 23.063h-0.625v-10.563h0.625zM9.25 23.063h-0.625v-11.25h0.625zM10.563 23.063h-0.625v-11.563h0.625zM12.188 23.063h-0.688v-11.25h0.688zM13.438 23.063h-0.625v-10.875h0.625zM14.75 23.063h-0.688v-12.188h0.688zM16.313 23.063h-0.625v-13.125h0.625zM28.063 22.938c-0.063 0-10.938 0-10.938 0-0.25 0-0.5-0.188-0.5-0.438v-12.5c0-0.25 0.125-0.375 0.438-0.5 0.75-0.313 1.625-0.438 2.5-0.438 3.625 0 6.625 2.75 6.938 6.313 0.5-0.188 1-0.313 1.563-0.313 2.188 0 3.938 1.75 3.938 3.938s-1.75 3.938-3.938 3.938z"></path></svg>',
        'behance' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M28.813 9.25h-8v-1.875h8zM15.563 16.813c0.625 0.875 0.938 1.875 0.938 3.125 0 1-0.188 1.875-0.563 2.563-0.438 0.75-0.938 1.313-1.563 1.813-0.688 0.438-1.438 0.75-2.25 1-0.813 0.188-1.688 0.313-2.563 0.313h-9.563v-19.875h9.25c0.938 0 1.813 0.188 2.625 0.375 0.75 0.188 1.375 0.5 1.938 0.875s1 0.938 1.313 1.563c0.313 0.563 0.438 1.375 0.438 2.313s-0.188 1.813-0.688 2.438c-0.438 0.688-1.125 1.25-2 1.625 1.25 0.375 2.125 1 2.688 1.875zM4.188 13.75h4.5c0.813 0 1.438-0.063 1.938-0.438s0.75-0.875 0.75-1.75c0-0.438-0.063-0.813-0.25-1.125-0.188-0.25-0.375-0.5-0.688-0.688-0.25-0.125-0.563-0.313-0.938-0.375s-0.75-0.125-1.125-0.125h-4.188zM12.188 19.688c0-1-0.313-1.688-0.875-2.125s-1.313-0.625-2.25-0.625h-4.875v5.438h4.75c0.438 0 0.875-0.063 1.25-0.125 0.375-0.125 0.688-0.25 1-0.438s0.563-0.438 0.688-0.813c0.188-0.313 0.313-0.75 0.313-1.313zM32 19.5h-10.313c0 1 0.375 2.188 1 2.75 0.563 0.563 1.438 0.875 2.5 0.875 0.813 0 1.5-0.25 2.063-0.688 0.563-0.375 0.875-0.688 1.063-1.313h3.438c-0.563 1.938-1.438 3-2.563 3.75s-2.5 1.188-4.125 1.188c-1.125 0-2.125-0.188-3.063-0.563-0.875-0.375-1.625-0.875-2.25-1.5-0.625-0.688-1.125-1.5-1.5-2.438-0.313-0.875-0.5-1.875-0.5-3 0-1.063 0.188-2.063 0.563-3 0.313-0.938 0.813-1.688 1.438-2.375 0.688-0.688 1.438-1.188 2.313-1.625 0.938-0.375 1.938-0.563 3-0.563 1.188 0 2.25 0.25 3.188 0.688 0.875 0.5 1.625 1.125 2.188 1.875 0.625 0.813 1 1.75 1.25 2.75s0.375 2.25 0.313 3.188zM28.063 16.938c-0.125-0.938-0.438-1.688-0.875-2.188-0.5-0.563-1.313-0.813-2.25-0.813-0.625 0-1.125 0.125-1.563 0.375-0.375 0.188-0.75 0.438-1 0.75s-0.375 0.625-0.5 1c-0.125 0.313-0.188 0.563-0.188 0.875z"></path></svg>',
        'foursquare' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M24.625 0c0 0-14.688 0-17.063 0-2.313 0-3 1.75-3 2.875s0 27.125 0 27.125c0 1.25 0.625 1.75 1 1.875 0.438 0.188 1.438 0.313 2.063-0.438 0 0 8.063-9.375 8.188-9.5 0.25-0.188 0.25-0.188 0.438-0.188 0.438 0 3.563 0 5.25 0 2.188 0 2.5-1.563 2.75-2.5 0.188-0.75 2.313-11.688 3.063-15.188 0.5-2.625-0.125-4.063-2.688-4.063zM24.25 19.25c0.188-0.75 2.313-11.688 3.063-15.188zM23.625 4.625l-0.688 3.75c-0.125 0.375-0.625 0.813-1.063 0.813-0.5 0-6.688 0-6.688 0-0.75 0-1.25 0.5-1.25 1.25v0.813c0 0.75 0.5 1.25 1.25 1.25 0 0 5.125 0 5.688 0 0.5 0 1 0.625 0.938 1.188-0.125 0.563-0.688 3.375-0.75 3.688-0.063 0.25-0.375 0.813-1.063 0.813-0.5 0-4.563 0-4.563 0-0.875 0-1.125 0.125-1.688 0.813s-5.563 6.75-5.563 6.75c-0.063 0.063-0.125 0.063-0.125 0v-21.188c0-0.5 0.438-1.063 1.063-1.063 0 0 13.125 0 13.688 0 0.5 0 0.938 0.5 0.813 1.125z"></path></svg>',
        'dribbble' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M15.938 0.125c-8.813 0-16 7.188-16 16s7.188 16 16 16c8.875 0 16-7.188 16-16s-7.125-16-16-16zM26.563 7.5c1.875 2.313 3.063 5.25 3.063 8.5-0.438-0.125-4.938-1-9.5-0.438-0.125-0.25-0.188-0.5-0.313-0.688-0.25-0.688-0.563-1.375-0.875-2 5-2.063 7.313-5 7.625-5.375zM15.938 2.438c3.5 0 6.688 1.313 9.063 3.438-0.188 0.375-2.25 3.125-7.125 4.938-2.25-4.063-4.75-7.438-5.125-8 1.063-0.25 2.125-0.375 3.188-0.375zM10.188 3.75c0.313 0.5 2.75 3.875 5.063 7.938-6.438 1.688-12.063 1.625-12.688 1.625 0.938-4.25 3.75-7.75 7.625-9.563zM2.313 16.125c0-0.125 0-0.25 0-0.438 0.563 0.063 7.188 0.125 14.063-1.938 0.375 0.75 0.75 1.563 1.063 2.313-0.188 0.063-0.313 0.125-0.5 0.188-7.063 2.25-10.813 8.5-11.125 9-2.188-2.438-3.5-5.625-3.5-9.125zM15.938 29.813c-3.125 0-6.063-1.125-8.375-2.875 0.25-0.563 3-5.875 10.75-8.563 0 0 0.063 0 0.063-0.063 1.938 5 2.75 9.188 2.938 10.375-1.625 0.688-3.438 1.125-5.375 1.125zM23.625 27.438c-0.188-0.813-0.875-4.813-2.688-9.75 4.313-0.688 8.063 0.438 8.5 0.625-0.563 3.813-2.75 7.063-5.813 9.125z"></path></svg>',
        'envato' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 28 32" width="28" height="32"><path d="M3.3,8.9c-7.3,10.2-0.7,18.5,3.6,21.2C12,33.2,22,33.2,26,24.4c5-11-0.9-23.5-2.3-24.2l0,0c-1.1-0.6-6.9,0.1-11.1,4.1C6,10.9,6.2,19.5,6.2,19.5S6,20.4,5,19.1c-2-2.6-1-8.5-0.8-9.4C4.3,8.6,3.6,8.5,3.3,8.9L3.3,8.9z"/></svg>',
        'rss' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M8.563 27.688c0 2.375-1.875 4.25-4.25 4.25s-4.25-1.875-4.25-4.25c0-2.313 1.875-4.25 4.25-4.25s4.25 1.938 4.25 4.25zM0.063 17c4 0 7.75 1.563 10.563 4.375s4.375 6.625 4.375 10.625h6.125c0-11.625-9.438-21.125-21.063-21.125zM0.063 6.125c14.188 0 25.75 11.625 25.75 25.875h6.125c0-17.625-14.313-32-31.875-32z"></path></svg>',
        'vine' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 28 32" width="28" height="32"><path class="st0" d="M28,15.9v3.8c-1.3,0.3-2.7,0.4-3.8,0.4c-2.7,5.6-7.5,10.5-9.1,11.4c-1,0.6-2,0.6-3.1-0.1c-2-1.2-9.5-7.3-12-26.7h5.4c1.4,11.6,4.7,17.6,8.4,22c2-2,4-4.7,5.5-7.8c-3.6-1.8-5.8-5.9-5.8-10.6c0-4.8,2.7-8.4,7.5-8.4c8.4,0,7.7,9.3,5.9,13.2c0,0-3.4,0.7-4.6-1.5c0.2-0.8,0.6-2.2,0.6-3.5c0-2.3-0.8-3.4-2.1-3.4c-1.3,0-2.2,1.2-2.2,3.6C18.5,14.2,22.9,17.1,28,15.9L28,15.9z"/></svg>',
        'slideshare' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32" width="32" height="32"><path class="st0" d="M11.7,9.6c-2.1,0-3.9,1.6-3.9,3.6c0,2,1.7,3.6,3.9,3.6s3.9-1.6,3.9-3.6C15.6,11.2,13.9,9.6,11.7,9.6L11.7,9.6z M20.7,9.6c-2.1,0-3.9,1.6-3.9,3.6c0,2,1.7,3.6,3.9,3.6c2.1,0,3.9-1.6,3.9-3.6C24.6,11.2,22.8,9.6,20.7,9.6L20.7,9.6z M30.5,15.2l-0.4,0.3V3.1c0-1.7-1.3-3.1-2.9-3.1H4.8C3.2,0,1.9,1.4,1.9,3.1v12.4c-0.1-0.1-0.3-0.2-0.4-0.3c-0.9-0.7-1.6,0.2-1,1.1c1.1,1.4,3.3,3.1,6.6,4.5c-3.5,12,8.6,13.9,8.4,7.8c0,0,0-3.5,0-6c0.3,0.1,0.6,0.1,0.9,0.2c0,2.5,0,5.8,0,5.8c-0.2,6.1,11.9,4.2,8.4-7.7c3.3-1.4,5.5-3.1,6.6-4.5C32.1,15.5,31.4,14.6,30.5,15.2z M28.6,16.4c-4.3,2.3-8,1.9-10,1.9c-1.5-0.1-2,0.6-2.1,1.6c-0.6-0.5-1.2-1-1.3-1.1c-0.3-0.3-0.9-0.5-1.7-0.5c-2,0.1-5.6,0.5-9.8-1.7v-12c0-2.2,0.6-2.9,2.5-2.9H26c1.9,0,2.6,0.8,2.6,2.9L28.6,16.4L28.6,16.4z"/></svg>',
        '500px' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M7.904 21.024c0 0.032 0.16 0.48 0.256 0.704 0.512 1.248 1.28 2.368 2.24 3.328s2.080 1.728 3.328 2.24c1.28 0.544 2.656 0.832 4.064 0.832s2.784-0.288 4.064-0.832c1.248-0.512 2.368-1.28 3.328-2.24s1.728-2.080 2.24-3.328c0.544-1.28 0.832-2.656 0.832-4.064s-0.288-2.784-0.832-4.064c-0.512-1.248-1.28-2.368-2.24-3.328s-2.080-1.728-3.328-2.24c-1.28-0.544-2.656-0.832-4.064-0.832-1.44 0-2.848 0.288-4.128 0.832-1.024 0.416-2.752 1.536-3.744 2.592v0-8.672h14.496c0.512 0 0.512-0.736 0.512-0.992s0-0.992-0.544-0.992l-15.616 0.032c-0.416 0-0.704 0.352-0.704 0.672v12.128c0 0.384 0.48 0.672 0.928 0.768 0.896 0.192 1.088-0.096 1.312-0.384l0.032-0.032c0.32-0.48 1.376-1.536 1.376-1.536 1.6-1.6 3.776-2.496 6.080-2.496s4.448 0.896 6.048 2.496c1.632 1.632 2.496 3.776 2.496 6.048s-0.896 4.416-2.496 6.048c-1.6 1.6-3.808 2.496-6.080 2.496-1.536 0-3.040-0.416-4.32-1.184v-7.392c0-0.992 0.416-2.048 1.152-2.848 0.832-0.928 1.952-1.44 3.168-1.44 1.184 0 2.304 0.448 3.136 1.28 0.832 0.8 1.28 1.888 1.28 3.040 0 2.464-1.952 4.384-4.416 4.384-0.48 0-1.344-0.224-1.376-0.224-0.512-0.16-0.704 0.544-0.768 0.768-0.256 0.864 0.128 1.056 0.224 1.088 0.8 0.256 1.312 0.288 2.016 0.288 3.488 0 6.336-2.848 6.336-6.336 0-3.456-2.848-6.304-6.336-6.304-1.696 0-3.328 0.64-4.512 1.856-1.152 1.12-1.824 2.624-1.824 4.128v0.032c0 0.192 0 4.608 0 6.048v0c-0.672-0.736-1.312-1.856-1.728-2.976-0.16-0.448-0.544-0.352-1.056-0.192-0.288 0.096-0.992 0.288-0.832 0.8v0zM15.36 19.296c0 0.224 0.192 0.384 0.32 0.512v0.032c0.192 0.192 0.384 0.288 0.576 0.288 0.16 0 0.224-0.064 0.256-0.096 0.096-0.096 1.088-1.088 1.184-1.184l1.12 1.088c0.096 0.128 0.224 0.16 0.352 0.192 0.192 0 0.384-0.096 0.576-0.32 0.48-0.48 0.224-0.736 0.128-0.864l-1.12-1.12 1.152-1.184c0.256-0.288 0.032-0.576-0.192-0.8-0.32-0.32-0.64-0.416-0.832-0.224l-1.152 1.152-1.184-1.184c-0.064-0.064-0.128-0.096-0.224-0.096-0.16 0-0.352 0.096-0.544 0.32-0.352 0.352-0.448 0.608-0.256 0.8l1.184 1.184-1.152 1.184c-0.16 0.096-0.192 0.224-0.192 0.32zM17.92 3.424c-1.888 0-3.872 0.384-5.344 1.024-0.16 0.064-0.256 0.192-0.256 0.352-0.032 0.16 0.032 0.384 0.128 0.672 0.096 0.224 0.32 0.864 0.8 0.672 1.504-0.576 3.168-0.896 4.672-0.896 1.728 0 3.36 0.32 4.928 0.992 1.248 0.512 2.4 1.28 3.68 2.4 0.096 0.096 0.192 0.128 0.288 0.128 0.256 0 0.48-0.256 0.704-0.48 0.352-0.384 0.576-0.704 0.224-1.024-1.216-1.152-2.56-2.016-4.192-2.72-1.792-0.736-3.68-1.12-5.632-1.12zM28 26.592v0c-0.224-0.224-0.416-0.352-0.576-0.416s-0.32 0-0.448 0.096l-0.096 0.128c-1.152 1.152-2.528 2.080-4.032 2.72-1.568 0.672-3.232 0.992-4.928 0.992s-3.36-0.32-4.928-0.992c-1.504-0.64-2.848-1.536-4.032-2.72-1.216-1.216-2.112-2.56-2.72-4.032-0.576-1.408-0.768-2.496-0.832-2.848 0-0.032 0-0.064 0-0.064-0.064-0.416-0.448-0.448-0.992-0.352-0.224 0.032-0.928 0.128-0.864 0.64v0c0.192 1.152 0.512 2.272 0.96 3.36 0.736 1.728 1.792 3.296 3.104 4.608 1.344 1.344 2.88 2.4 4.608 3.104 1.792 0.768 3.712 1.152 5.664 1.152s3.872-0.384 5.664-1.152c1.728-0.736 3.296-1.792 4.608-3.104 0 0 0.064-0.064 0.128-0.128 0.192-0.128 0.32-0.416-0.288-0.992z"></path></svg>',
        'flickr' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M7.25 23.25c-4 0-7.25-3.25-7.25-7.25s3.25-7.25 7.25-7.25c4 0 7.25 3.25 7.25 7.25s-3.25 7.25-7.25 7.25zM24.75 23.25c-4 0-7.25-3.25-7.25-7.25s3.25-7.25 7.25-7.25c4 0 7.25 3.25 7.25 7.25s-3.25 7.25-7.25 7.25z"></path></svg>',
        'wp_posts' => '<svg width="28" height="32" version="1.1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 28 32" ><path class="st0" d="M27.1,4.1l-3.2-3.2C23.3,0.3,22.6,0,21.8,0H11C9.3,0,8,1.3,8,3v3H3C1.3,6,0,7.3,0,9v20c0,1.7,1.3,3,3,3h14c1.7,0,3-1.3,3-3v-3h5c1.7,0,3-1.3,3-3V6.2C28,5.4,27.7,4.7,27.1,4.1z M16.6,29H3.4C3.2,29,3,28.8,3,28.6V9.4C3,9.2,3.2,9,3.4,9H8v14c0,1.7,1.3,3,3,3h6v2.6C17,28.8,16.8,29,16.6,29z M24.6,23H11.4c-0.2,0-0.4-0.2-0.4-0.4V3.4C11,3.2,11.2,3,11.4,3H18v5.5c0,0.8,0.7,1.5,1.5,1.5H25v12.6C25,22.8,24.8,23,24.6,23z M25,7h-4V3h0.6c0.1,0,0.2,0,0.3,0.1l3,3C25,6.2,25,6.3,25,6.4V7z"/></svg>',
        'wp_comments' => '<svg version="1.1" width="42" height="32" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 42 32" ><path d="M38.4,25.3c2-1.9,3.1-4.4,3.1-7C41.6,12.6,36.1,7.8,29,7c-2.3-4.1-7.5-7-13.7-7C7.1,0,0.4,5.1,0.4,11.4c0,2.6,1.2,5.1,3.1,7c-1.1,2.2-2.7,3.9-2.7,3.9c-0.5,0.5-0.6,1.2-0.3,1.8c0.3,0.6,0.9,1,1.5,1c3.8,0,6.9-1.4,8.9-2.8c0.7,0.2,1.3,0.3,2,0.4c2.2,4.1,7.5,7,13.7,7c1.5,0,2.9-0.2,4.3-0.5c2,1.3,5.1,2.8,8.9,2.8c0.7,0,1.3-0.4,1.5-1c0.3-0.6,0.1-1.3-0.3-1.8C41.1,29.2,39.5,27.5,38.4,25.3z M10.4,18.7l-1.2,0.8c-1,0.6-2,1.2-3.1,1.5c0.2-0.3,0.4-0.7,0.6-1.1l1.1-2.2L6,16c-1-1-2.1-2.5-2.1-4.6c0-4.3,5.2-8,11.4-8s11.4,3.7,11.4,8s-5.2,8-11.4,8c-1.2,0-2.4-0.1-3.5-0.4L10.4,18.7L10.4,18.7z M36,22.9l-1.8,1.7l1.1,2.2c0.2,0.4,0.4,0.7,0.6,1.1c-1-0.4-2.1-0.9-3.1-1.5l-1.2-0.8l-1.4,0.3c-1.1,0.3-2.3,0.4-3.5,0.4c-3.9,0-7.3-1.4-9.4-3.6c7.2-0.8,12.8-5.5,12.8-11.3c0-0.2,0-0.5-0.1-0.7c4.6,1,8,4.1,8,7.6C38.1,20.3,37,21.9,36,22.9z"/></svg>',
        'wp_users' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 46 32" width="46" height="32"><path d="M13.9,16c4.4,0,8-3.6,8-8s-3.6-8-8-8s-8,3.6-8,8S9.4,16,13.9,16z M19.3,18.3h-0.6c-1.5,0.7-3.1,1.1-4.9,1.1S10.5,19,9,18.3H8.4c-4.5,0-8.2,3.7-8.2,8.2v2.1c0,1.9,1.5,3.4,3.4,3.4h20.6c1.9,0,3.4-1.5,3.4-3.4v-2.1C27.6,22,23.9,18.3,19.3,18.3z M34.4,16c3.8,0,6.9-3.1,6.9-6.9s-3.1-6.9-6.9-6.9c-3.8,0-6.9,3.1-6.9,6.9S30.6,16,34.4,16z M37.9,18.3h-0.3c-1,0.3-2,0.6-3.2,0.6c-1.1,0-2.2-0.2-3.2-0.6H31c-1.5,0-2.8,0.4-4,1.1c1.7,1.9,2.8,4.4,2.8,7.1v2.7c0,0.2,0,0.3,0,0.5h12.6c1.9,0,3.4-1.5,3.4-3.4C45.9,21.9,42.3,18.3,37.9,18.3z"/></svg>',
        'steamcommunity' => '<svg version="1.1" width="32" height="32" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32" ><path class="st0" d="M32,16c0,8.8-7.2,16-16,16C8.6,32,2.5,27.1,0.6,20.4l6.1,2.5c0.4,2.1,2.3,3.6,4.4,3.6c2.5,0,4.6-2.1,4.5-4.7l5.5-3.9c3.4,0.1,6.2-2.6,6.2-6c0-3.3-2.7-6-6-6s-6,2.7-6,6V12l-3.8,5.5c-1-0.1-2,0.2-2.8,0.8L0,14.7C0.7,6.5,7.6,0,16,0C24.8,0,32,7.2,32,16z M10,24.3l-2-0.8c0.4,0.8,1,1.3,1.8,1.7c1.7,0.7,3.7-0.1,4.5-1.8c0.3-0.8,0.4-1.8,0-2.6s-1-1.5-1.8-1.8c-0.8-0.3-1.7-0.3-2.5,0l2,0.8c1.3,0.5,1.9,2,1.3,3.3C12.8,24.2,11.3,24.8,10,24.3z M21.3,15.9c-2.2,0-4-1.8-4-4s1.8-4,4-4s4,1.8,4,4S23.5,15.9,21.3,15.9z M21.3,14.9c1.7,0,3-1.4,3-3c0-1.7-1.4-3-3-3s-3,1.4-3,3C18.2,13.5,19.6,14.9,21.3,14.9z"/></svg>',
        'feedly' => '<svg version="1.1" width="37" height="32" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 37 32" ><path fill="none" d="M19.5,15.4c-0.1-0.1-0.3-0.2-0.6-0.2c-0.2,0-0.4,0.1-0.6,0.2l-7.1,7.1c-0.1,0.1-0.2,0.3-0.2,0.6c0,0.2,0.1,0.4,0.2,0.6l1,1c0.1,0.1,0.3,0.2,0.5,0.2h1.7c0.2,0,0.4-0.1,0.6-0.2l6.2-6.2c0.3-0.3,0.3-0.8,0-1.1L19.5,15.4z"/><path fill="none" d="M20.7,8.4l-1.9-1.9c-0.1-0.1-0.3-0.2-0.6-0.2c-0.2,0-0.4,0.1-0.6,0.2L6.5,17.8c-0.1,0.1-0.2,0.3-0.2,0.6c0,0.2,0.1,0.4,0.2,0.6l1,1c0.1,0,0.3,0.1,0.5,0.1h1.7c0.2,0,0.4-0.1,0.5-0.2L20.7,9.5C21,9.2,21,8.7,20.7,8.4z"/><path d="M35.8,15.6L21.4,1.2C20.6,0.4,19.6,0,18.5,0s-2.1,0.4-2.9,1.2L1.2,15.6c-1.6,1.6-1.6,4.1,0,5.7l9.5,9.5c0.8,0.8,1.8,1.2,2.9,1.2h9.9h0.1c1.1,0,2.1-0.4,2.9-1.2l9.4-9.5c0.8-0.8,1.2-1.8,1.2-2.9C37,17.4,36.5,16.4,35.8,15.6z M10.3,19.9c-0.1,0.1-0.3,0.2-0.5,0.2H8c-0.2,0-0.4-0.1-0.6-0.2l-1-1c-0.1-0.1-0.2-0.3-0.2-0.6c0-0.2,0.1-0.4,0.2-0.6L17.7,6.5c0.1-0.1,0.3-0.2,0.6-0.2c0.2,0,0.4,0.1,0.6,0.2l1.9,1.9c0.3,0.3,0.3,0.8,0,1.1L10.3,19.9z M20.6,28.1L20.6,28.1c-0.1,0.1-0.1,0.1-0.1,0.1l-1,1c-0.1,0.1-0.3,0.2-0.5,0.2h-1.8c-0.2,0-0.4-0.1-0.5-0.2l-1-1c-0.1-0.2-0.2-0.4-0.2-0.6c0-0.3,0.1-0.5,0.2-0.6l1.8-1.9c0.1-0.1,0.3-0.1,0.4-0.2c0.1-0.1,0.3-0.1,0.5-0.1c0.2,0,0.4,0.1,0.6,0.2l1.9,1.9C20.9,27.3,20.9,27.8,20.6,28.1z M21.4,18.4l-6.2,6.2c-0.1,0.1-0.3,0.2-0.6,0.2h-1.7c-0.2,0-0.4-0.1-0.5-0.2l-1-1c-0.1-0.1-0.2-0.3-0.2-0.6c0-0.2,0.1-0.4,0.2-0.6l7.1-7.1c0.1-0.1,0.3-0.2,0.6-0.2c0.2,0,0.4,0.1,0.6,0.2l1.9,1.9C21.7,17.6,21.7,18.1,21.4,18.4z"/></svg>',
        'spotify' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M25.813 25.938c-0.375 0.625-1.25 0.875-1.875 0.438-5.313-3.188-11.938-3.938-19.75-2.125-0.75 0.125-1.5-0.313-1.688-1.063s0.313-1.5 1.063-1.688c8.563-1.938 15.875-1.125 21.813 2.5 0.688 0.375 0.875 1.25 0.438 1.938zM28.563 19.813c-0.5 0.813-1.563 1.063-2.375 0.563-6.063-3.688-15.25-4.75-22.438-2.625-0.875 0.313-1.875-0.25-2.188-1.125-0.25-0.938 0.25-1.938 1.188-2.188 8.188-2.5 18.313-1.313 25.25 2.938 0.813 0.563 1.125 1.625 0.563 2.438zM31.688 12.688c-0.563 1-1.875 1.313-2.875 0.75-7.25-4.313-19.188-4.688-26.125-2.625-1.063 0.375-2.25-0.25-2.625-1.375-0.313-1.125 0.313-2.313 1.438-2.625 7.938-2.438 21.125-1.938 29.5 3 1 0.625 1.313 1.875 0.688 2.875z"></path></svg>',
        'twitch' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M22.938 27.813h-6.25l-4.188 4.188h-4.125v-4.188h-7.688v-22.25l2.125-5.563h28.5v19.5zM28.5 18.063v-15.313h-22.938v20.188h6.25v4.188l4.188-4.188h7.625zM20.875 8.375v8.313h2.75v-8.313zM13.188 16.688h2.813v-8.313h-2.813z"></path></svg>',
        'periscope' => '<svg version="1.1" width="26" height="32" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 26 32"><path d="M25.7,13.2C25.7,6,20,0,13.2,0C6,0,0.3,6,0.3,13.2c0,7.5,10,18.8,12.8,18.8C15.7,32,25.7,20.7,25.7,13.2z M5.3,12.7c0-1.9,0.6-3.5,1.6-4.8v0c0,1.7,1.3,3,3,3c1.7,0,3.1-1.4,3.1-3c0-1.2-0.7-2.3-1.8-2.7c0.6-0.2,1.3-0.2,2-0.2c4,0,7.5,3.4,7.5,7.8c0,4-3.5,7.4-7.5,7.4C8.7,20.1,5.3,16.7,5.3,12.7L5.3,12.7z"/></svg>'
         
    );    
    
    public static function register_custom() {
        if (has_filter('essb_custom_svg_icons')) {
            self::$icons = apply_filters( 'essb_custom_svg_icons', self::$icons );
        }

        if (has_filter('essb_custom_svg_icon_aliases')) {
            self::$aliases = apply_filters( 'essb_custom_svg_icon_aliases', self::$aliases );
        }
    }
    
    /**
     * Return SVG icon code
     * 
     * @param string $icon
     * @return NULL|string
     */
    public static function get_icon($icon = '', $fill = '') {
        $list = self::get_all();
        
        /**
         * Check if alias exists only if networks does not have an icon
         */
        if (!array_key_exists( $icon, $list ) && array_key_exists( $icon, self::$aliases )) {
            $icon = self::$aliases[$icon];
        }
        
        if ( array_key_exists( $icon, $list ) ) {
            $repl = '<svg class="essb-svg-icon" aria-hidden="true" role="img" focusable="false" ';
            
            if (!empty($fill)) {
                $repl .= 'fill="'.esc_attr($fill).'" ';    
            }
            
            $svg  = preg_replace( '/^<svg /', $repl, trim( $list[ $icon ] ) ); // Add extra attributes to SVG code.
            $svg  = preg_replace( "/([\n\t]+)/", ' ', $svg ); // Remove newlines & tabs.
            $svg  = preg_replace( '/>\s*</', '><', $svg );    // Remove whitespace between SVG tags.
            
            // Make sure that only our allowed tags and attributes are included.
            $svg = wp_kses(
                $svg,
                array(
                    'svg'     => array(
                        'class'       => true,
                        'xmlns'       => true,
                        'width'       => true,
                        'height'      => true,
                        'viewbox'     => true,
                        'aria-hidden' => true,
                        'role'        => true,
                        'focusable'   => true,
                    ),
                    'path'    => array(
                        'fill'      => true,
                        'fill-rule' => true,
                        'd'         => true,
                        'transform' => true,
                    ),
                    'polygon' => array(
                        'fill'      => true,
                        'fill-rule' => true,
                        'points'    => true,
                        'transform' => true,
                        'focusable' => true,
                    ),
                )
                );
            
            if ( ! $svg ) {
                return null;
            }
            
            return $svg;
        }
        
        return null;
    }
    
    /**
     * Return all icons with filter applying. Custom icons can be added via the essb_svg_icons filter
     * @return array
     */
    public static function get_all() {
        if (has_filter('essb_svg_icons')) {
            return apply_filters( 'essb_svg_icons', self::$icons );
        }
        else {
            return self::$icons;
        }
    }
}